/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser.actualize;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.checkparser.BaseCheckDataParser;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Parser12LaserRadiationActualize
extends BaseCheckDataParser {
    private Integer[] targetIds = new Integer[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 168, 169, 170, 170};

    @Override
    protected List<CheckResult> doParseData(SheetModel sheetModel, ImportCheckParamBo param) throws ParseException {
        String sheetName = sheetModel.getSheetName();
        this.logger.info("\u89e3\u6790\u68c0\u6d4b\u6570\u636e->" + sheetName);
        List rows = sheetModel.getRows();
        if (rows.size() <= 1) {
            this.logger.warn(sheetName + "\u65e0\u68c0\u6d4b\u6570\u636e");
            return Collections.emptyList();
        }
        Long resultNo = null;
        LinkedList<CheckResult> list = new LinkedList<CheckResult>();
        Object exceptionMsg = "";
        for (int i = 1; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            resultNo = this.snowFlake.nextId();
            for (int j = 0; j < row.size(); ++j) {
                CheckResult result = new CheckResult();
                list.add(result);
                result.setTargetId(this.targetIds[j]);
                result.setResultNo(resultNo);
                String value = (String)row.get(j);
                if (!(j > 4 && j != 8 || value != null && value.length() != 0)) {
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                if (j == 1) {
                    value = this.getTouchType(value);
                }
                if (j == 3) {
                    value = this.getLightType(value);
                }
                if (j >= 5 && j <= 7) {
                    if (value != null && !value.isEmpty()) {
                        result.setCheckValueRangeType(this.getRangeType(value.substring(0, 1)));
                    } else {
                        result.setCheckValueRangeType(Integer.valueOf(1));
                    }
                    try {
                        value = this.parseValue(value);
                    }
                    catch (ParseException e) {
                        exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + value;
                        exceptionMsg = (String)exceptionMsg + "<br/>";
                    }
                }
                if (j == 8) {
                    value = this.getJudgeResult(value);
                }
                if (j == 2 || j == 4) {
                    if (value != null) {
                        value = value.replaceAll(" ", "");
                    }
                    if (this.setRangeValue(result, value)) continue;
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u683c\u5f0f\u4e0d\u6b63\u786e";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                result.setCheckValue(value);
            }
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException((String)exceptionMsg);
        }
        return list;
    }

    private String getTouchType(String value) {
        switch (value) {
            case "\u76ae\u80a4": {
                return "2";
            }
        }
        return "1";
    }

    private String getLightType(String value) {
        switch (value) {
            case "\u7d2b\u5916\u7ebf": {
                return "1";
            }
            case "\u53ef\u89c1\u5149": {
                return "2";
            }
            case "\u7ea2\u5916\u7ebf": {
                return "3";
            }
            case "\u8fdc\u7ea2\u5916\u7ebf": {
                return "4";
            }
        }
        return "";
    }

    private String parseValue(String value) throws ParseException {
        if (value.isEmpty()) {
            return value;
        }
        if (value.startsWith("<") || value.startsWith("-") || value.startsWith("\uff1c") || value.startsWith("\u2264")) {
            value = value.substring(1);
        }
        try {
            Object newValue = "";
            newValue = (String)newValue + value.substring(0, 1);
            Integer.parseInt((String)newValue);
            newValue = (String)newValue + ",";
            newValue = (String)newValue + value.substring(value.indexOf("^") + 1, value.indexOf("~"));
            newValue = (String)newValue + ",";
            newValue = (String)newValue + value.substring(value.indexOf("~") + 1, value.lastIndexOf("*"));
            newValue = (String)newValue + ",";
            newValue = (String)newValue + value.substring(value.lastIndexOf("^") + 1);
            return newValue;
        }
        catch (Exception e) {
            throw new ParseException("\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e:" + value);
        }
    }
}

