/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser.actualize;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.api.service.IRaySourceDeviceService;
import cn.smarthse.services.hfi.checkparser.BaseCheckDataParser;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Parser10IonizingRadiationRaySourceDeviceActualize
extends BaseCheckDataParser {
    private IRaySourceDeviceService raySourceDeviceService;
    private Integer[] targetIds = new Integer[]{80, 80, 80, 80, 80, 80, 80, 81, 82, 83, 160, 161, 162, 163};

    @Autowired
    public void autowired(IRaySourceDeviceService raySourceDeviceService) {
        this.raySourceDeviceService = raySourceDeviceService;
    }

    @Override
    protected List<CheckResult> doParseData(SheetModel sheetModel, ImportCheckParamBo param) throws ParseException {
        String sheetName = sheetModel.getSheetName();
        this.logger.info("\u89e3\u6790\u68c0\u6d4b\u6570\u636e->" + sheetName);
        List rows = sheetModel.getRows();
        if (rows.size() <= 1) {
            this.logger.warn(sheetName + "\u65e0\u68c0\u6d4b\u6570\u636e");
            return Collections.emptyList();
        }
        LinkedList<CheckResult> list = new LinkedList<CheckResult>();
        int startRow = 1;
        for (startRow = 1; startRow < rows.size(); ++startRow) {
            String deviceName = (String)((RowModel)rows.get(startRow)).get(0);
            if (deviceName.length() <= 0) continue;
            this.pareThisData(rows, list, sheetName, startRow, param);
        }
        return list;
    }

    private void setIonizingValue(CheckResult result, String value) {
        try {
            Double.parseDouble(value);
            result.setCheckValueRangeType(Integer.valueOf(1));
            result.setCheckValueMin(value);
            result.setCheckValueMax(value);
        }
        catch (NumberFormatException e) {
            result.setCheckValueRangeType(this.getRangeType(value.substring(0, 1)));
            result.setCheckValueMax(value.substring(1));
            result.setCheckValueMin(value.substring(1));
        }
    }

    private void pareThisData(List<RowModel> rows, List<CheckResult> list, String sheetName, int startRow, ImportCheckParamBo param) throws ParseException {
        int endRow;
        RaySourceDevice rayDevice = new RaySourceDevice();
        List<Integer> cols = Arrays.asList(0, 1, 3, 5, 6);
        for (Integer col : cols) {
            String v = (String)rows.get(startRow).get(col.intValue());
            if (v.length() != 0) continue;
            throw new ParseException(sheetName + "\u7b2c" + (startRow + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (endRow = startRow + 1; endRow < rows.size() && ((String)rows.get(endRow).get(0)).length() <= 0; ++endRow) {
        }
        rayDevice.setName((String)rows.get(startRow).get(0));
        rayDevice.setRaySourceNo((String)rows.get(startRow).get(1));
        rayDevice.setSignNo((String)rows.get(startRow).get(2));
        rayDevice.setNucleusEl((String)rows.get(startRow).get(3));
        rayDevice.setNowActiveDegree((String)rows.get(startRow).get(4));
        rayDevice.setFactoryActiveDegree((String)rows.get(startRow).get(5));
        rayDevice.setInstallLocation((String)rows.get(startRow).get(6));
        rayDevice.setCreateBy(param.getCreateUserId());
        rayDevice.setCheckId(param.getCheckId());
        rayDevice.setIsValid(Boolean.valueOf(true));
        rayDevice.setCreateDate(LocalDateTime.now());
        rayDevice.setUpdateDate(LocalDateTime.now());
        this.raySourceDeviceService.save((Object)rayDevice);
        for (int j = startRow; j < endRow; ++j) {
            Long resultNo = this.snowFlake.nextId();
            CheckResult result = new CheckResult();
            list.add(result);
            result.setTargetId(Integer.valueOf(80));
            result.setResultNo(resultNo);
            result.setCheckValue("" + rayDevice.getId());
            for (int k = 7; k <= 13 && k < rows.get(j).size(); ++k) {
                result = new CheckResult();
                list.add(result);
                result.setTargetId(this.targetIds[k]);
                result.setResultNo(resultNo);
                String value = (String)rows.get(j).get(k);
                if (value == null || value.length() == 0) {
                    throw new ParseException(sheetName + "\u7b2c" + (j + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (k == 9) {
                    value = this.getJudgeResult(value);
                }
                if (k == 8) {
                    this.setRangeValue(result, value);
                    continue;
                }
                result.setCheckValue(value);
            }
        }
    }
}

