/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.checkparser.BaseCheckDataParser;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Parser1Chemical
extends BaseCheckDataParser {
    private Integer[] odlTargetIds = new Integer[]{124, 125, 126, 1, 2, 5, 3, 4, 9, 192, 10};
    private Integer[] newTargetIds = new Integer[]{124, 125, 126, 1, 2, 6, 3, 7, 8, 192, 10};

    @Override
    protected List<CheckResult> doParseData(SheetModel sheetModel, ImportCheckParamBo param) throws ParseException {
        Integer[] targetIds = null;
        if (param.getStandardId().equals(1L)) {
            targetIds = this.odlTargetIds;
        } else if (param.getStandardId().equals(2L)) {
            targetIds = this.newTargetIds;
        }
        String sheetName = sheetModel.getSheetName();
        this.logger.info("\u89e3\u6790\u68c0\u6d4b\u6570\u636e->" + sheetName);
        List rows = sheetModel.getRows();
        if (rows.size() <= 2) {
            this.logger.warn(sheetName + "\u65e0\u68c0\u6d4b\u6570\u636e");
            return Collections.emptyList();
        }
        Long resultNo = null;
        LinkedList<CheckResult> list = new LinkedList<CheckResult>();
        Object exceptionMsg = "";
        block2: for (int i = 2; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            resultNo = this.snowFlake.nextId();
            int n = 0;
            for (int j = 0; j < row.size(); ++j) {
                CheckResult result = new CheckResult();
                list.add(result);
                result.setTargetId(targetIds[j]);
                result.setResultNo(resultNo);
                String value = (String)row.get(j);
                if (!(j != 3 && j != 4 && j != 0 && j != 1 && j != 2 || value != null && value.length() != 0)) {
                    exceptionMsg = sheetName + "\u7b2c" + (i + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                if (j == 4) {
                    try {
                        value = this.getFactorIdValue(value, "\u5316\u5b66\u56e0\u7d20", param);
                    }
                    catch (ParseException e) {
                        exceptionMsg = (String)exceptionMsg + e.getMessage();
                        exceptionMsg = (String)exceptionMsg + "<br/>";
                        continue block2;
                    }
                }
                if (j == 10) {
                    value = this.getJudgeResult(value);
                }
                if (j == 7 || j == 5 || j == 6 || j == 8) {
                    if (value != null) {
                        value = value.replaceAll(" ", "");
                    }
                    if (!this.setRangeValue(result, value)) {
                        exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u683c\u5f0f\u4e0d\u6b63\u786e";
                        exceptionMsg = (String)exceptionMsg + "<br/>";
                        continue block2;
                    }
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    ++n;
                    continue;
                }
                result.setCheckValue(value);
            }
            if (n != 0) continue;
            exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a";
            exceptionMsg = (String)exceptionMsg + "<br/>";
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException((String)exceptionMsg);
        }
        return list;
    }
}

