/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser;

import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.checkparser.CheckDataParser;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseCheckDataParser
implements CheckDataParser {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected IdWorker snowFlake;
    private Map<Long, Map<String, String>> checkIdToFactorMap = new HashMap<Long, Map<String, String>>();
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @Autowired
    private ICheckPlanService checkPlanService;

    @Override
    public synchronized List<CheckResult> parseData(SheetModel sheetModel, ImportCheckParamBo param, Map<String, String> factorNameToIdMap) throws ParseException {
        this.checkIdToFactorMap.put(param.getCheckId(), factorNameToIdMap);
        return this.doParseData(sheetModel, param);
    }

    protected abstract List<CheckResult> doParseData(SheetModel var1, ImportCheckParamBo var2) throws ParseException;

    protected String getJudgeResult(String judgeResultValue) {
        switch (judgeResultValue) {
            case "\u7b26\u5408": {
                return "2";
            }
            case "\u4e0d\u7b26\u5408": {
                return "3";
            }
            case "\u4e0d\u5224\u5b9a": {
                return "1";
            }
        }
        return "";
    }

    protected String filterRange(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        if (value.startsWith("<") || value.startsWith("\uff1c") || value.startsWith("\u2264")) {
            value = value.substring(1);
        }
        return value;
    }

    protected Integer getRangeType(String symbol) {
        switch (symbol) {
            case "<": 
            case "\uff1c": {
                return 2;
            }
            case "\u2264": {
                return 3;
            }
        }
        return 1;
    }

    protected boolean setRangeValue(CheckResult result, String v) {
        String value = v;
        if (value.isEmpty()) {
            result.setCheckValue("");
            result.setCheckValueRangeType(Integer.valueOf(1));
            result.setCheckValueMax("");
            result.setCheckValueMin("");
            return true;
        }
        try {
            Double.parseDouble(value);
            result.setCheckValue("");
            result.setCheckValueRangeType(Integer.valueOf(1));
            result.setCheckValueMax(value);
            result.setCheckValueMin(value);
            return true;
        }
        catch (NumberFormatException e) {
            if (value.contains("(") && value.contains(")")) {
                value = value.substring(0, value.indexOf("("));
            }
            try {
                int startIndex = 1;
                if (value.charAt(0) >= '0' && value.charAt(0) <= '9') {
                    startIndex = 0;
                }
                Integer rangeType = this.getRangeType(value.substring(0, 1));
                if (!(value = value.replace("\uff5e", "~")).contains("~")) {
                    String minValue;
                    String maxValue = minValue = value.substring(startIndex);
                    Double.parseDouble(minValue);
                    Double.parseDouble(maxValue);
                    result.setCheckValueRangeType(rangeType);
                    result.setCheckValueMin(minValue);
                    result.setCheckValueMax(maxValue);
                    return true;
                }
                int index = value.indexOf("~");
                String minValue = value.substring(startIndex, index);
                String maxValue = value.substring(index + 1);
                Double.parseDouble(minValue);
                Double.parseDouble(maxValue);
                result.setCheckValueRangeType(rangeType);
                result.setCheckValueMin(minValue);
                result.setCheckValueMax(maxValue);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.logger.error("\u8bbe\u7f6e\u68c0\u6d4b\u7ed3\u679c\u8303\u56f4\u503c\u5f02\u5e38\uff1avalue=" + value, (Throwable)e);
                return false;
            }
            return true;
        }
    }

    protected boolean setRangeValue2(CheckResult result, String value) {
        try {
            Integer rangeType = this.getRangeType("");
            int index = value.indexOf("~");
            String minValue = value.substring(0, index);
            String maxValue = value.substring(index + 1);
            Double.parseDouble(minValue);
            Double.parseDouble(maxValue);
            result.setCheckValueRangeType(rangeType);
            result.setCheckValueMin(minValue);
            result.setCheckValueMax(maxValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8bbe\u7f6e\u68c0\u6d4b\u7ed3\u679c\u8303\u56f4\u503c\u5f02\u5e38\uff1avalue=" + value, (Throwable)e);
            return false;
        }
        return true;
    }

    protected String getFactorIdValue(String factorName, String harmType, ImportCheckParamBo paramBo) throws ParseException {
        Object id;
        Map<String, String> factorNameToIdMap = this.checkIdToFactorMap.get(paramBo.getCheckId());
        if (factorName != null) {
            factorName = factorName.trim();
        }
        if ((id = factorNameToIdMap.get(factorName)) == null) {
            id = factorNameToIdMap.get(BaseCheckDataParser.toDBC(factorName));
        }
        if (id == null) {
            this.logger.warn("\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728:" + factorName);
            if (factorName.contains("\u5176\u4ed6") && factorName.contains(harmType)) {
                HarmFactor harmFactor = this.harmFactorService.addByNameAndType(factorName, harmType, paramBo.getCid(), paramBo.getCreateUserId());
                id = "" + harmFactor.getId();
                factorNameToIdMap.put(harmFactor.getNameCh(), "" + harmFactor.getId());
            } else {
                throw new ParseException(ParseException.NO_FACTOR, harmType + "\uff1a\"" + factorName + "\"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u5982\u679c\u662f\u5176\u4ed6" + harmType + "\u8bf7\u6309\"\u5176\u4ed6" + harmType + "(\u5177\u4f53\u6210\u5206)\"\u586b\u5199");
            }
        }
        return id;
    }

    public static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }
}

