/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.cache;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.services.hfi.api.model.StatComModel;
import cn.smarthse.services.hfi.comservice.ComDbDataService;
import com.carrotsearch.sizeof.RamUsageEstimator;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StatComModelCache {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ComDbDataService comDbDataService;
    private Cache<Long, List<StatComModel>> commonCache = Caffeine.newBuilder().maximumSize(Integer.MAX_VALUE).build();
    private final Long key = 1L;
    private volatile int status = 2;
    @Autowired
    private ThreadPoolExecutor executor;
    private LocalDateTime refreshTime = null;
    private static final int EXPIRE_MINUTE = 180;

    public void init() {
        long s = System.currentTimeMillis();
        List<StatComModel> allComAreaModel = this.comDbDataService.getAllStatComModel();
        this.clear();
        this.putAll(allComAreaModel);
        long e = System.currentTimeMillis();
        long byteSize = 0L;
        if (!CollectionUtils.isEmpty(allComAreaModel)) {
            byteSize = RamUsageEstimator.sizeOf((Object)allComAreaModel.get(0)) * (long)allComAreaModel.size();
        }
        this.logger.info("\u83b7\u53d6\u6240\u6709\u4f01\u4e1a\u6570\u636e\u5230\u7f13\u5b58,\u8017\u65f6:" + (e - s) / 1000L + "\u79d2;size=" + allComAreaModel.size() + ";\u6240\u5360\u5185\u5b58:" + byteSize / 0x100000L + "M");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache() {
        if (this.status == 1) {
            return;
        }
        Long l = this.key;
        synchronized (l) {
            if (this.status == 1) {
                return;
            }
            this.status = 1;
        }
        this.init();
        this.status = 2;
    }

    private void putAll(List<StatComModel> list) {
        this.commonCache.put((Object)this.key, list);
    }

    public List<StatComModel> getAll() {
        List all = (List)this.commonCache.getIfPresent((Object)this.key);
        if (this.refreshTime == null || DateUtil.caculateMinutes((LocalDateTime)LocalDateTime.now(), (LocalDateTime)this.refreshTime) > 180L) {
            this.executor.execute(() -> {
                this.refreshCache();
                this.refreshTime = LocalDateTime.now();
            });
        }
        return all;
    }

    private List<StatComModel> get(Long key) {
        return (List)this.commonCache.getIfPresent((Object)key);
    }

    private void put(Long key, List<StatComModel> value) {
        this.commonCache.put((Object)key, value);
    }

    private void delete(Long key) {
        this.commonCache.invalidate((Object)key);
    }

    public void clear() {
        this.commonCache.invalidateAll();
    }
}

