/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.cache;

import cn.smarthse.modules.datacentre.model.system.IndustrialClassification;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IndustrialCache {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference(version="1.0.0", timeout=60000)
    private ISysParamProvideService sysParamProvideService;
    private Cache<Long, String> commonCache = Caffeine.newBuilder().maximumSize(Integer.MAX_VALUE).build();

    @PostConstruct
    public void init() {
        this.logger.info("\u52a0\u8f7d\u884c\u4e1a....");
        List list = this.sysParamProvideService.getIndustrialClassification();
        for (IndustrialClassification classification : list) {
            this.put(classification.getId(), classification.getName());
        }
        this.logger.info("\u52a0\u8f7d\u884c\u4e1a\u5b8c\u6210....");
    }

    public String get(Long key) {
        return (String)this.commonCache.getIfPresent((Object)key);
    }

    public void put(Long key, String value) {
        this.commonCache.put((Object)key, (Object)value);
    }

    public void delete(Long key) {
        this.commonCache.invalidate((Object)key);
    }

    public void clear() {
        this.commonCache.invalidateAll();
    }
}

