/*同步表*/
drop table  if exists sys_area;
create table sys_area
(
    id            bigint unsigned                    not null comment 'ID'
        primary key,
    parent_id     bigint                             not null comment '父编号',
    short_name    varchar(255) charset utf8          null comment '简称',
    name          varchar(255) charset utf8          null comment '名称',
    py            varchar(100) charset utf8          null comment '简拼',
    py_full       varchar(100) charset utf8          null comment '全拼',
    lng           varchar(20) charset utf8           null comment '经度',
    lat           varchar(20) charset utf8           null comment '纬度',
    level         tinyint  default 0                 null comment '级别(0-国家,1-省,2-市,3-区、县,4-乡、镇、街道,5-村、居委会)',
    order_by      int                                null comment '热度',
    sort          bigint(22)                         null comment '同一级的区域排序字段(默认为id值)',
    province_id   bigint unsigned                    null comment '省编号',
    province_name varchar(255) charset utf8          null comment '省名称',
    city_id       bigint unsigned                    null comment '市编号',
    city_name     varchar(255) charset utf8          null comment '市名称',
    area_id       bigint unsigned                    null comment '区域ID',
    area_name     varchar(255) charset utf8          null comment '区域名称',
    street_id     bigint unsigned                    null comment '乡镇街道编号',
    street_name   varchar(500) charset utf8          null comment '乡镇街道名称',
    is_valid      bit      default b'1'              null comment '是否有效（0-无效，1-有效）',
    create_by     bigint                             null comment '创建者',
    create_date   datetime   null comment '创建时间',
    update_by     bigint                             null comment '更新者',
    update_date   datetime   null comment '更新时间'
);

create index IDX_DISTRICT_LEVEL
    on sys_area (level, parent_id);

create index IDX_DISTRICT_PARENT
    on sys_area (parent_id);

-- auto-generated definition
drop table  if exists company;
create table company
(
    id                         bigint unsigned          not null comment 'ID'
        primary key,
    name                       varchar(100)             null comment 'fullname企业名称',
    company_type               tinyint     default 1    not null comment '企业类型：1用人单位， 2外包单位',
    short_name                 varchar(100)             null comment '企业名称简称',
    father_dept                varchar(100)             null comment '上属公司（或主管单位）',
    setting_time               date                     null comment '成立时间',
    unified_social_cc          varchar(100)             null comment 'corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）',
    company_contact_tel        varchar(50)              null comment 'corp_tel 企业联系电话	',
    company_contact_email      varchar(50)              null comment 'corp_email 企业电子邮箱',
    company_contact_fax        varchar(20)              null comment '企业传真',
    area_id                    bigint unsigned          null comment 'corp_area_id 行政区域区编号',
    register_address           varchar(100)             null comment '企业注册地详址',
    register_post              varchar(6)               null comment '企业注册地址邮编',
    company_postal_adress      varchar(500)             null comment 'corp_address 企业通讯地址',
    work_address               varchar(100)             null comment '工作产所地址（工作场所地址）',
    register_type              bigint                   null comment '注册类型',
    industry_category          bigint                   null comment 'corp_type 行业分类（sys_param.param_code）',
    occupational_risk_classify tinyint                  null comment '职业病危害风险分类(0-严重、1-较重、2-一般)',
    staff_count                int(5)                   null comment '在岗职工人数',
    pickup_count               int(5)      default 0    null comment '接害人数（不重复计）',
    main_opera_income          decimal(10, 2)           null comment '主营营业收入（万元）',
    register_capital           decimal(10, 2)           null comment '注册资本',
    scale                      varchar(100)             null comment '企业规模',
    year_assets                decimal(10, 2)           null comment '企业年度产值',
    total_assets               decimal(10, 2)           null comment '企业资产总值',
    legal_name                 varchar(100)             null comment '法人代表姓名',
    legal_tel                  varchar(100)             null comment '法人代表联系电话',
    chemical_emergency_phone   varchar(45)              null comment '化学事故应急咨询服务电话',
    occ_leader_sid             bigint unsigned          null comment '职业卫生负责人',
    occ_leader_tel             varchar(20)              null comment '职业卫生负责人联系电话',
    occ_manager_name           varchar(30) default ''   not null comment '职业卫生管理联系人',
    occ_manager_tel            varchar(30) default ''   not null comment '职业卫生管理联系人电话',
    create_date                datetime                 null comment '创建时间',
    create_by                  bigint unsigned          null comment '创建人',
    update_date                datetime                 null comment '最后修改时间',
    update_by                  bigint unsigned          null comment '最后修改人ID',
    is_valid                   bit         default b'1' null comment '是否有效（0-无效，1-有效）',
    data_source                tinyint                  null comment '数据来源,CompanyDataSourceEnum约定',
    logo_file_url              varchar(500)             null comment '企业logo url 地址',
    corp_cc_extend             varchar(100)             null comment '平台字段）企业编号串扩展(社会统一信代码/登记号/组织代码)',
    lng                        varchar(20) default ''   not null comment '经度',
    lat                        varchar(20) default ''   not null comment '纬度'
)
    comment '企业信息' charset = utf8;

create index index2
    on company (name);

create index index3
    on company (is_valid);

create index index4
    on company (area_id);

create index index5
    on company (industry_category);

create index index6
    on company (unified_social_cc);

create index index7
    on company (company_contact_email);



-- auto-generated definition
drop table  if exists third_organization;
create table third_organization
(
    id                                    bigint                 not null comment '主键id'
        primary key,
    name                                  varchar(256)           not null comment '机构名称',
    legal_person                          varchar(96)            not null comment '法定代表人',
    legal_person_phone                    varchar(64)            not null comment '法定代表人电话',
    contact_name                          varchar(96)            null comment '联系人',
    contact_phone                         varchar(64)            null comment '联系人电话',
    province_id                           bigint                 null comment '省份id',
    city_id                               bigint                 null comment '城市id',
    area_id                               bigint                 null comment '区域id',
    province_name                         varchar(256)           null comment '省份名称',
    city_name                             varchar(256)           null comment '城市名称',
    area_name                             varchar(256)           null comment '区县名称',
    address                               varchar(512)           null comment '详细地址',
    org_type                              int                    null comment '1：检测评价机构 2：体检机构 4:诊断机构 8：鉴定机构',
    level                                 int         default 0  not null comment '资质等级（检测评价机构才有该字段） 0：无， 1：甲， 2：乙， 3：丙',
    record_manage_unit_dic_id             bigint      default 0  not null comment '备案主管单位字典id (0表示无)',
    create_date                           datetime               not null comment '创建时间',
    create_by                             bigint unsigned        not null comment '创建人id（监管端登录用户id）',
    update_date                           datetime               not null comment '最后修改时间',
    update_by                             bigint unsigned        not null comment '最后修改人id(监管端或机构端登录用户id)',
    is_valid                              tinyint(1)  default 1  not null comment '是否有效(逻辑删除)',
    unit_web                              varchar(128)           null comment '单位网址(检测评价机构)',
    principal                             varchar(128)           null comment '主要负责人(检测评价机构)',
    principal_phone                       varchar(32)            null comment '主要负责人手机(检测评价机构)',
    certificate_no                        varchar(128)           null comment '资质证书编号(检测评价机构)',
    technicist_num                        int                    null comment '专业技术人员数(检测评价机构)',
    high_technicist_num                   int                    null comment '高级职称人数(检测评价机构)',
    middle_technicist_num                 int                    null comment '中级职称人数(检测评价机构)',
    technology_principal                  varchar(128)           null comment '专业技术负责人(检测评价机构)',
    technology_principal_title            varchar(128)           null comment '专业技术负责人技术职称(检测评价机构)',
    technology_principal_qualification_no varchar(128)           null comment '专业技术负责人培训合格证证号(检测评价机构)',
    quality_principal                     varchar(128)           null comment '质量控制负责人(检测评价机构)',
    quality_principal_title               varchar(128)           null comment '质量控制负责人技术职称(检测评价机构)',
    quality_principal_qualification_no    varchar(128)           null comment '质量控制负责人培训合格证证号(检测评价机构)',
    test_data                             tinyint(1)  default 0  null comment '是否是测试机构,默认false',
    cid                                   bigint      default 0  not null comment '所属集团企业id(集团版该字段有效)',
    is_enable                             tinyint(1)  default 1  not null comment '是否启用 默认 是',
    credit_code                           varchar(64) default '' null comment '社会统一信用代码（体检机构）',
    can_out_check                         tinyint(1)             null comment '能否开展外出职业健康检查（体检机构）',
    org_types                             varchar(64)            null comment '当前机构具有的类型'
)
    comment '第三方机构-机构表(create by 邓力宾)' charset = utf8;