/*统计表*/
DROP TABLE IF EXISTS `com_over_rate`;
CREATE TABLE `com_over_rate` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `cid` bigint NOT NULL  COMMENT '企业id',
  `c_name` varchar(512)  default  null comment '企业名称',
  `chemical_rate` char(8) NOT NULL default 0 COMMENT '化学毒物超标率',
  `dust_rate` char(8) not null default 0 COMMENT '粉尘超标率',
  `noise_values` varchar(512) default null COMMENT '噪声检测值（多个用英文逗号隔开）',
  `total_rate` char(8) default 0 not null  comment '总超标率',
  `work_address` varchar(512) comment '工作地址',
   is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
   create_by   bigint unsigned     not null default 0 comment '创建人',
   create_date datetime             null   comment '创建时间',
   update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
   update_date datetime             null  comment '最后修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='企业超标率统计结果表（监管需求02-046）';

drop table  if exists  check_factor;
create table check_factor
(
    id          bigint          default 0 not null comment 'id'
        primary key,
    cid         bigint               null comment '企业id',
    check_id    bigint                       null comment '检测id',
    factor_id   bigint               null comment '涉及到的危害因素id',
    factor_name varchar(256)         null comment   '危害因素名称',
    is_valid    tinyint(1)      default 1 not null comment '是否有效（0-无效，1-有效）',
    create_by   bigint unsigned default 0 not null comment '创建人',
    create_date datetime                  null comment '创建时间',
    update_by   bigint unsigned default 0 not null comment '最后修改人ID',
    update_date datetime                  null comment '最后修改时间'
)
    comment '检测涉及的危害因素表（统计表）';

drop table if exists  check_over_point;
create table check_over_point
(
    id          bigint          default 0 not null comment 'id'
        primary key,
    cid         bigint                    null comment '企业id',
    check_id    bigint                    null comment '检测id',
    check_point  int                      default 0 comment  '检测点',
    pass_point   int                      default 0  comment '合格点',
    over_point   int                      default 0  comment '超标点',
    is_valid    tinyint(1)      default 1 not null comment '是否有效（0-无效，1-有效）',
    create_by   bigint unsigned default 0 not null comment '创建人',
    create_date datetime                  null comment '创建时间',
    update_by   bigint unsigned default 0 not null comment '最后修改人ID',
    update_date datetime                  null comment '最后修改时间'
)
    comment '检测超标统计（统计表）';