/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class WindSpeedListModel
extends BaseResultListMode {
    private String checkResult;

    public static WindSpeedListModel covert(List<CheckResult> results) {
        WindSpeedListModel model = new WindSpeedListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(false);
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 121) {
                model.setCheckObject(checkValue);
            } else if (targetId == 122) {
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 123) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(191).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(188).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(189).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<WindSpeedListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<WindSpeedListModel> models = new ArrayList<WindSpeedListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            WindSpeedListModel model = WindSpeedListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    @Generated
    public WindSpeedListModel() {
    }

    @Generated
    public String getCheckResult() {
        return this.checkResult;
    }

    @Generated
    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindSpeedListModel)) {
            return false;
        }
        WindSpeedListModel other = (WindSpeedListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$checkResult = this.getCheckResult();
        String other$checkResult = other.getCheckResult();
        return !(this$checkResult == null ? other$checkResult != null : !this$checkResult.equals(other$checkResult));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindSpeedListModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $checkResult = this.getCheckResult();
        result = result * 59 + ($checkResult == null ? 43 : $checkResult.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WindSpeedListModel(checkResult=" + this.getCheckResult() + ")";
    }
}

