/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class PowerFrequencyListModel
extends BaseResultListMode {
    private String contactTime;
    private String powerLevel;

    public static PowerFrequencyListModel covert(List<CheckResult> results) {
        PowerFrequencyListModel model = new PowerFrequencyListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            if (l.getIsRisk() == null) {
                model.setIsRisk(true);
            } else {
                model.setIsRisk(l.getIsRisk());
            }
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 53) {
                model.setCheckObject(checkValue);
            } else if (targetId == 54) {
                model.setContactTime(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 55) {
                model.setPowerLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 56) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(144).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(145).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(146).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<PowerFrequencyListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<PowerFrequencyListModel> models = new ArrayList<PowerFrequencyListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            PowerFrequencyListModel model = PowerFrequencyListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    @Generated
    public PowerFrequencyListModel() {
    }

    @Generated
    public String getContactTime() {
        return this.contactTime;
    }

    @Generated
    public String getPowerLevel() {
        return this.powerLevel;
    }

    @Generated
    public void setContactTime(String contactTime) {
        this.contactTime = contactTime;
    }

    @Generated
    public void setPowerLevel(String powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerFrequencyListModel)) {
            return false;
        }
        PowerFrequencyListModel other = (PowerFrequencyListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contactTime = this.getContactTime();
        String other$contactTime = other.getContactTime();
        if (this$contactTime == null ? other$contactTime != null : !this$contactTime.equals(other$contactTime)) {
            return false;
        }
        String this$powerLevel = this.getPowerLevel();
        String other$powerLevel = other.getPowerLevel();
        return !(this$powerLevel == null ? other$powerLevel != null : !this$powerLevel.equals(other$powerLevel));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerFrequencyListModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contactTime = this.getContactTime();
        result = result * 59 + ($contactTime == null ? 43 : $contactTime.hashCode());
        String $powerLevel = this.getPowerLevel();
        result = result * 59 + ($powerLevel == null ? 43 : $powerLevel.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerFrequencyListModel(contactTime=" + this.getContactTime() + ", powerLevel=" + this.getPowerLevel() + ")";
    }
}

