/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class MicroclimateListModel
extends BaseResultListMode {
    private String tempResult;
    private String tempJudged;
    private String speedResult;
    private String speedJudged;
    private String humidityResult;
    private String humidityJudged;

    public static MicroclimateListModel covert(List<CheckResult> results) {
        MicroclimateListModel model = new MicroclimateListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(false);
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 108) {
                model.setCheckObject(checkValue);
            } else if (targetId == 109) {
                model.setTempResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 110) {
                model.setTempJudged(JudgeStateEnum.getName(checkValue));
            } else if (targetId == 111) {
                model.setSpeedResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 112) {
                model.setSpeedJudged(JudgeStateEnum.getName(checkValue));
            } else if (targetId == 113) {
                model.setHumidityResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 114) {
                model.setHumidityJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(180).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(181).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(182).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<MicroclimateListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<MicroclimateListModel> models = new ArrayList<MicroclimateListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            MicroclimateListModel model = MicroclimateListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    @Generated
    public MicroclimateListModel() {
    }

    @Generated
    public String getTempResult() {
        return this.tempResult;
    }

    @Generated
    public String getTempJudged() {
        return this.tempJudged;
    }

    @Generated
    public String getSpeedResult() {
        return this.speedResult;
    }

    @Generated
    public String getSpeedJudged() {
        return this.speedJudged;
    }

    @Generated
    public String getHumidityResult() {
        return this.humidityResult;
    }

    @Generated
    public String getHumidityJudged() {
        return this.humidityJudged;
    }

    @Generated
    public void setTempResult(String tempResult) {
        this.tempResult = tempResult;
    }

    @Generated
    public void setTempJudged(String tempJudged) {
        this.tempJudged = tempJudged;
    }

    @Generated
    public void setSpeedResult(String speedResult) {
        this.speedResult = speedResult;
    }

    @Generated
    public void setSpeedJudged(String speedJudged) {
        this.speedJudged = speedJudged;
    }

    @Generated
    public void setHumidityResult(String humidityResult) {
        this.humidityResult = humidityResult;
    }

    @Generated
    public void setHumidityJudged(String humidityJudged) {
        this.humidityJudged = humidityJudged;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroclimateListModel)) {
            return false;
        }
        MicroclimateListModel other = (MicroclimateListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tempResult = this.getTempResult();
        String other$tempResult = other.getTempResult();
        if (this$tempResult == null ? other$tempResult != null : !this$tempResult.equals(other$tempResult)) {
            return false;
        }
        String this$tempJudged = this.getTempJudged();
        String other$tempJudged = other.getTempJudged();
        if (this$tempJudged == null ? other$tempJudged != null : !this$tempJudged.equals(other$tempJudged)) {
            return false;
        }
        String this$speedResult = this.getSpeedResult();
        String other$speedResult = other.getSpeedResult();
        if (this$speedResult == null ? other$speedResult != null : !this$speedResult.equals(other$speedResult)) {
            return false;
        }
        String this$speedJudged = this.getSpeedJudged();
        String other$speedJudged = other.getSpeedJudged();
        if (this$speedJudged == null ? other$speedJudged != null : !this$speedJudged.equals(other$speedJudged)) {
            return false;
        }
        String this$humidityResult = this.getHumidityResult();
        String other$humidityResult = other.getHumidityResult();
        if (this$humidityResult == null ? other$humidityResult != null : !this$humidityResult.equals(other$humidityResult)) {
            return false;
        }
        String this$humidityJudged = this.getHumidityJudged();
        String other$humidityJudged = other.getHumidityJudged();
        return !(this$humidityJudged == null ? other$humidityJudged != null : !this$humidityJudged.equals(other$humidityJudged));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MicroclimateListModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tempResult = this.getTempResult();
        result = result * 59 + ($tempResult == null ? 43 : $tempResult.hashCode());
        String $tempJudged = this.getTempJudged();
        result = result * 59 + ($tempJudged == null ? 43 : $tempJudged.hashCode());
        String $speedResult = this.getSpeedResult();
        result = result * 59 + ($speedResult == null ? 43 : $speedResult.hashCode());
        String $speedJudged = this.getSpeedJudged();
        result = result * 59 + ($speedJudged == null ? 43 : $speedJudged.hashCode());
        String $humidityResult = this.getHumidityResult();
        result = result * 59 + ($humidityResult == null ? 43 : $humidityResult.hashCode());
        String $humidityJudged = this.getHumidityJudged();
        result = result * 59 + ($humidityJudged == null ? 43 : $humidityJudged.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MicroclimateListModel(tempResult=" + this.getTempResult() + ", tempJudged=" + this.getTempJudged() + ", speedResult=" + this.getSpeedResult() + ", speedJudged=" + this.getSpeedJudged() + ", humidityResult=" + this.getHumidityResult() + ", humidityJudged=" + this.getHumidityJudged() + ")";
    }
}

