/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class HighFrequencyListModel
extends BaseResultListMode {
    private String rate;
    private String hour;
    private String powerLevel;
    private String freLevel;

    public static HighFrequencyListModel covert(List<CheckResult> results) {
        HighFrequencyListModel model = new HighFrequencyListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            if (l.getIsRisk() == null) {
                model.setIsRisk(true);
            } else {
                model.setIsRisk(l.getIsRisk());
            }
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 64) {
                model.setCheckObject(checkValue);
            } else if (targetId == 65) {
                model.setRate(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 66) {
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 67) {
                model.setPowerLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 68) {
                model.setFreLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 69) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(152).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(153).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(154).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<HighFrequencyListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<HighFrequencyListModel> models = new ArrayList<HighFrequencyListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            HighFrequencyListModel model = HighFrequencyListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    @Generated
    public HighFrequencyListModel() {
    }

    @Generated
    public String getRate() {
        return this.rate;
    }

    @Generated
    public String getHour() {
        return this.hour;
    }

    @Generated
    public String getPowerLevel() {
        return this.powerLevel;
    }

    @Generated
    public String getFreLevel() {
        return this.freLevel;
    }

    @Generated
    public void setRate(String rate) {
        this.rate = rate;
    }

    @Generated
    public void setHour(String hour) {
        this.hour = hour;
    }

    @Generated
    public void setPowerLevel(String powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Generated
    public void setFreLevel(String freLevel) {
        this.freLevel = freLevel;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HighFrequencyListModel)) {
            return false;
        }
        HighFrequencyListModel other = (HighFrequencyListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rate = this.getRate();
        String other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !this$rate.equals(other$rate)) {
            return false;
        }
        String this$hour = this.getHour();
        String other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !this$hour.equals(other$hour)) {
            return false;
        }
        String this$powerLevel = this.getPowerLevel();
        String other$powerLevel = other.getPowerLevel();
        if (this$powerLevel == null ? other$powerLevel != null : !this$powerLevel.equals(other$powerLevel)) {
            return false;
        }
        String this$freLevel = this.getFreLevel();
        String other$freLevel = other.getFreLevel();
        return !(this$freLevel == null ? other$freLevel != null : !this$freLevel.equals(other$freLevel));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HighFrequencyListModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : $rate.hashCode());
        String $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : $hour.hashCode());
        String $powerLevel = this.getPowerLevel();
        result = result * 59 + ($powerLevel == null ? 43 : $powerLevel.hashCode());
        String $freLevel = this.getFreLevel();
        result = result * 59 + ($freLevel == null ? 43 : $freLevel.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HighFrequencyListModel(rate=" + this.getRate() + ", hour=" + this.getHour() + ", powerLevel=" + this.getPowerLevel() + ", freLevel=" + this.getFreLevel() + ")";
    }
}

