/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class DustListModel
extends BaseResultListMode {
    private String totalTwa;
    private String totalRange;
    private String totalPeak;
    private String totalOverTimes;
    private String reductionFactorTotal;
    private String totalResult;
    private String respTwa;
    private String respRange;
    private String respPeak;
    private String respOverTimes;
    private String reductionFactorResp;
    private String respResult;

    public static DustListModel covert(List<CheckResult> results, Map<String, String> allHarmMap) {
        DustListModel model = new DustListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            if (l.getIsRisk() == null) {
                model.setIsRisk(true);
            } else {
                model.setIsRisk(l.getIsRisk());
            }
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 11) {
                model.setCheckObject(checkValue);
            } else if (targetId == 12) {
                String s = (String)allHarmMap.get(checkValue);
                if (s != null) {
                    model.setCheckProject(s);
                    model.setHarmId(checkValue);
                } else {
                    model.setCheckProject(checkValue);
                    model.setHarmId("");
                }
            } else if (targetId == 13) {
                model.setTotalTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 14) {
                model.setTotalRange(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 15) {
                model.setTotalPeak(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 16) {
                model.setTotalOverTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 17) {
                model.setTotalResult(JudgeStateEnum.getName(checkValue));
            } else if (targetId == 18) {
                model.setRespTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 19) {
                model.setRespRange(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 20) {
                model.setRespPeak(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 21) {
                model.setRespOverTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 22) {
                model.setRespResult(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(128).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(129).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(130).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            } else if (Integer.valueOf(193).equals(targetId)) {
                model.setReductionFactorTotal(checkValue);
            } else if (Integer.valueOf(195).equals(targetId)) {
                model.setReductionFactorResp(checkValue);
            }
        });
        return model;
    }

    public static List<DustListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap, Map<String, String> allHarmMap) {
        ArrayList<DustListModel> models = new ArrayList<DustListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            DustListModel model = DustListModel.covert(rowList, allHarmMap);
            models.add(model);
        }
        return models;
    }

    @Generated
    public DustListModel() {
    }

    @Generated
    public String getTotalTwa() {
        return this.totalTwa;
    }

    @Generated
    public String getTotalRange() {
        return this.totalRange;
    }

    @Generated
    public String getTotalPeak() {
        return this.totalPeak;
    }

    @Generated
    public String getTotalOverTimes() {
        return this.totalOverTimes;
    }

    @Generated
    public String getReductionFactorTotal() {
        return this.reductionFactorTotal;
    }

    @Generated
    public String getTotalResult() {
        return this.totalResult;
    }

    @Generated
    public String getRespTwa() {
        return this.respTwa;
    }

    @Generated
    public String getRespRange() {
        return this.respRange;
    }

    @Generated
    public String getRespPeak() {
        return this.respPeak;
    }

    @Generated
    public String getRespOverTimes() {
        return this.respOverTimes;
    }

    @Generated
    public String getReductionFactorResp() {
        return this.reductionFactorResp;
    }

    @Generated
    public String getRespResult() {
        return this.respResult;
    }

    @Generated
    public void setTotalTwa(String totalTwa) {
        this.totalTwa = totalTwa;
    }

    @Generated
    public void setTotalRange(String totalRange) {
        this.totalRange = totalRange;
    }

    @Generated
    public void setTotalPeak(String totalPeak) {
        this.totalPeak = totalPeak;
    }

    @Generated
    public void setTotalOverTimes(String totalOverTimes) {
        this.totalOverTimes = totalOverTimes;
    }

    @Generated
    public void setReductionFactorTotal(String reductionFactorTotal) {
        this.reductionFactorTotal = reductionFactorTotal;
    }

    @Generated
    public void setTotalResult(String totalResult) {
        this.totalResult = totalResult;
    }

    @Generated
    public void setRespTwa(String respTwa) {
        this.respTwa = respTwa;
    }

    @Generated
    public void setRespRange(String respRange) {
        this.respRange = respRange;
    }

    @Generated
    public void setRespPeak(String respPeak) {
        this.respPeak = respPeak;
    }

    @Generated
    public void setRespOverTimes(String respOverTimes) {
        this.respOverTimes = respOverTimes;
    }

    @Generated
    public void setReductionFactorResp(String reductionFactorResp) {
        this.reductionFactorResp = reductionFactorResp;
    }

    @Generated
    public void setRespResult(String respResult) {
        this.respResult = respResult;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DustListModel)) {
            return false;
        }
        DustListModel other = (DustListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$totalTwa = this.getTotalTwa();
        String other$totalTwa = other.getTotalTwa();
        if (this$totalTwa == null ? other$totalTwa != null : !this$totalTwa.equals(other$totalTwa)) {
            return false;
        }
        String this$totalRange = this.getTotalRange();
        String other$totalRange = other.getTotalRange();
        if (this$totalRange == null ? other$totalRange != null : !this$totalRange.equals(other$totalRange)) {
            return false;
        }
        String this$totalPeak = this.getTotalPeak();
        String other$totalPeak = other.getTotalPeak();
        if (this$totalPeak == null ? other$totalPeak != null : !this$totalPeak.equals(other$totalPeak)) {
            return false;
        }
        String this$totalOverTimes = this.getTotalOverTimes();
        String other$totalOverTimes = other.getTotalOverTimes();
        if (this$totalOverTimes == null ? other$totalOverTimes != null : !this$totalOverTimes.equals(other$totalOverTimes)) {
            return false;
        }
        String this$reductionFactorTotal = this.getReductionFactorTotal();
        String other$reductionFactorTotal = other.getReductionFactorTotal();
        if (this$reductionFactorTotal == null ? other$reductionFactorTotal != null : !this$reductionFactorTotal.equals(other$reductionFactorTotal)) {
            return false;
        }
        String this$totalResult = this.getTotalResult();
        String other$totalResult = other.getTotalResult();
        if (this$totalResult == null ? other$totalResult != null : !this$totalResult.equals(other$totalResult)) {
            return false;
        }
        String this$respTwa = this.getRespTwa();
        String other$respTwa = other.getRespTwa();
        if (this$respTwa == null ? other$respTwa != null : !this$respTwa.equals(other$respTwa)) {
            return false;
        }
        String this$respRange = this.getRespRange();
        String other$respRange = other.getRespRange();
        if (this$respRange == null ? other$respRange != null : !this$respRange.equals(other$respRange)) {
            return false;
        }
        String this$respPeak = this.getRespPeak();
        String other$respPeak = other.getRespPeak();
        if (this$respPeak == null ? other$respPeak != null : !this$respPeak.equals(other$respPeak)) {
            return false;
        }
        String this$respOverTimes = this.getRespOverTimes();
        String other$respOverTimes = other.getRespOverTimes();
        if (this$respOverTimes == null ? other$respOverTimes != null : !this$respOverTimes.equals(other$respOverTimes)) {
            return false;
        }
        String this$reductionFactorResp = this.getReductionFactorResp();
        String other$reductionFactorResp = other.getReductionFactorResp();
        if (this$reductionFactorResp == null ? other$reductionFactorResp != null : !this$reductionFactorResp.equals(other$reductionFactorResp)) {
            return false;
        }
        String this$respResult = this.getRespResult();
        String other$respResult = other.getRespResult();
        return !(this$respResult == null ? other$respResult != null : !this$respResult.equals(other$respResult));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DustListModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $totalTwa = this.getTotalTwa();
        result = result * 59 + ($totalTwa == null ? 43 : $totalTwa.hashCode());
        String $totalRange = this.getTotalRange();
        result = result * 59 + ($totalRange == null ? 43 : $totalRange.hashCode());
        String $totalPeak = this.getTotalPeak();
        result = result * 59 + ($totalPeak == null ? 43 : $totalPeak.hashCode());
        String $totalOverTimes = this.getTotalOverTimes();
        result = result * 59 + ($totalOverTimes == null ? 43 : $totalOverTimes.hashCode());
        String $reductionFactorTotal = this.getReductionFactorTotal();
        result = result * 59 + ($reductionFactorTotal == null ? 43 : $reductionFactorTotal.hashCode());
        String $totalResult = this.getTotalResult();
        result = result * 59 + ($totalResult == null ? 43 : $totalResult.hashCode());
        String $respTwa = this.getRespTwa();
        result = result * 59 + ($respTwa == null ? 43 : $respTwa.hashCode());
        String $respRange = this.getRespRange();
        result = result * 59 + ($respRange == null ? 43 : $respRange.hashCode());
        String $respPeak = this.getRespPeak();
        result = result * 59 + ($respPeak == null ? 43 : $respPeak.hashCode());
        String $respOverTimes = this.getRespOverTimes();
        result = result * 59 + ($respOverTimes == null ? 43 : $respOverTimes.hashCode());
        String $reductionFactorResp = this.getReductionFactorResp();
        result = result * 59 + ($reductionFactorResp == null ? 43 : $reductionFactorResp.hashCode());
        String $respResult = this.getRespResult();
        result = result * 59 + ($respResult == null ? 43 : $respResult.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DustListModel(totalTwa=" + this.getTotalTwa() + ", totalRange=" + this.getTotalRange() + ", totalPeak=" + this.getTotalPeak() + ", totalOverTimes=" + this.getTotalOverTimes() + ", reductionFactorTotal=" + this.getReductionFactorTotal() + ", totalResult=" + this.getTotalResult() + ", respTwa=" + this.getRespTwa() + ", respRange=" + this.getRespRange() + ", respPeak=" + this.getRespPeak() + ", respOverTimes=" + this.getRespOverTimes() + ", reductionFactorResp=" + this.getReductionFactorResp() + ", respResult=" + this.getRespResult() + ")";
    }
}

