/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class BiologicalListModel
extends BaseResultListMode {
    private String me;
    private String mac;
    private String twa;
    private String ste;
    private String stel;
    private String reductionFactor;

    public static BiologicalListModel covert(List<CheckResult> results, Map<String, String> allHarmMap) {
        BiologicalListModel model = new BiologicalListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            if (l.getIsRisk() == null) {
                model.setIsRisk(true);
            } else {
                model.setIsRisk(l.getIsRisk());
            }
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 97) {
                model.setCheckObject(checkValue);
            } else if (targetId == 98) {
                String s = (String)allHarmMap.get(checkValue);
                if (s != null) {
                    model.setCheckProject(s);
                    model.setHarmId(checkValue);
                } else {
                    model.setCheckProject(checkValue);
                    model.setHarmId("");
                }
            } else if (targetId == 99) {
                model.setMac(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()) + ResultUtils.getBiologicalUnit(model.getHarmId(), l.getUnit()));
            } else if (targetId == 100) {
                model.setMe(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()) + ResultUtils.getBiologicalUnit(model.getHarmId(), l.getUnit()));
            } else if (targetId == 101) {
                model.setTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()) + ResultUtils.getBiologicalUnit(model.getHarmId(), l.getUnit()));
            } else if (targetId == 102) {
                model.setStel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()) + ResultUtils.getBiologicalUnit(model.getHarmId(), l.getUnit()));
            } else if (targetId == 103) {
                model.setSte(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()) + ResultUtils.getBiologicalUnit(model.getHarmId(), l.getUnit()));
            } else if (targetId == 104) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(172).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(173).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(174).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            } else if (Integer.valueOf(194).equals(targetId)) {
                model.setReductionFactor(checkValue);
            }
        });
        return model;
    }

    public static List<BiologicalListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap, Map<String, String> allHarmMap) {
        ArrayList<BiologicalListModel> models = new ArrayList<BiologicalListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            BiologicalListModel model = BiologicalListModel.covert(rowList, allHarmMap);
            models.add(model);
        }
        return models;
    }

    @Generated
    public BiologicalListModel() {
    }

    @Generated
    public String getMe() {
        return this.me;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getTwa() {
        return this.twa;
    }

    @Generated
    public String getSte() {
        return this.ste;
    }

    @Generated
    public String getStel() {
        return this.stel;
    }

    @Generated
    public String getReductionFactor() {
        return this.reductionFactor;
    }

    @Generated
    public void setMe(String me) {
        this.me = me;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setTwa(String twa) {
        this.twa = twa;
    }

    @Generated
    public void setSte(String ste) {
        this.ste = ste;
    }

    @Generated
    public void setStel(String stel) {
        this.stel = stel;
    }

    @Generated
    public void setReductionFactor(String reductionFactor) {
        this.reductionFactor = reductionFactor;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiologicalListModel)) {
            return false;
        }
        BiologicalListModel other = (BiologicalListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$me = this.getMe();
        String other$me = other.getMe();
        if (this$me == null ? other$me != null : !this$me.equals(other$me)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$twa = this.getTwa();
        String other$twa = other.getTwa();
        if (this$twa == null ? other$twa != null : !this$twa.equals(other$twa)) {
            return false;
        }
        String this$ste = this.getSte();
        String other$ste = other.getSte();
        if (this$ste == null ? other$ste != null : !this$ste.equals(other$ste)) {
            return false;
        }
        String this$stel = this.getStel();
        String other$stel = other.getStel();
        if (this$stel == null ? other$stel != null : !this$stel.equals(other$stel)) {
            return false;
        }
        String this$reductionFactor = this.getReductionFactor();
        String other$reductionFactor = other.getReductionFactor();
        return !(this$reductionFactor == null ? other$reductionFactor != null : !this$reductionFactor.equals(other$reductionFactor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BiologicalListModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $me = this.getMe();
        result = result * 59 + ($me == null ? 43 : $me.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $twa = this.getTwa();
        result = result * 59 + ($twa == null ? 43 : $twa.hashCode());
        String $ste = this.getSte();
        result = result * 59 + ($ste == null ? 43 : $ste.hashCode());
        String $stel = this.getStel();
        result = result * 59 + ($stel == null ? 43 : $stel.hashCode());
        String $reductionFactor = this.getReductionFactor();
        result = result * 59 + ($reductionFactor == null ? 43 : $reductionFactor.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BiologicalListModel(me=" + this.getMe() + ", mac=" + this.getMac() + ", twa=" + this.getTwa() + ", ste=" + this.getSte() + ", stel=" + this.getStel() + ", reductionFactor=" + this.getReductionFactor() + ")";
    }
}

