/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.entity.riskev;

import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import java.lang.reflect.Field;
import java.util.List;
import java.util.StringJoiner;

public class RiskExposeEvaluateDataUtil {
    private static int sequenceNumber = 1;

    public static String convertToString(List<RiskExposeEvaluateData> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return "";
        }
        sequenceNumber = 1;
        StringJoiner resultJoiner = new StringJoiner("\u3002  ");
        for (RiskExposeEvaluateData data : dataList) {
            String line = RiskExposeEvaluateDataUtil.buildLine(data);
            if (line.isEmpty()) continue;
            resultJoiner.add(line);
        }
        return resultJoiner.toString();
    }

    private static String buildLine(RiskExposeEvaluateData data) {
        String fieldValues;
        if (data == null) {
            return "";
        }
        StringJoiner lineJoiner = new StringJoiner(",");
        lineJoiner.add(String.valueOf(sequenceNumber++));
        String workshopPart = RiskExposeEvaluateDataUtil.buildWorkshopPart(data);
        if (!workshopPart.isEmpty()) {
            lineJoiner.add(workshopPart);
        }
        if (data.getFactorName() != null && !data.getFactorName().trim().isEmpty()) {
            lineJoiner.add(data.getFactorName());
        }
        if (!(fieldValues = RiskExposeEvaluateDataUtil.buildFieldValues(data)).isEmpty()) {
            lineJoiner.add(fieldValues);
        }
        return lineJoiner.toString().toUpperCase();
    }

    private static String buildWorkshopPart(RiskExposeEvaluateData data) {
        StringBuilder workshopPart = new StringBuilder();
        if (data.getWorkshop() != null && !data.getWorkshop().trim().isEmpty()) {
            workshopPart.append(data.getWorkshop());
        }
        if (data.getWorkName() != null && !data.getWorkName().trim().isEmpty()) {
            workshopPart.append(data.getWorkName());
        }
        return workshopPart.toString();
    }

    private static String buildFieldValues(RiskExposeEvaluateData data) {
        String[][] fieldsToProcess;
        StringJoiner fieldJoiner = new StringJoiner(",");
        for (String[] fieldInfo : fieldsToProcess = new String[][]{{"ctwa", "CTWA\u503c"}, {"cstel", "CSTEL\u503c"}, {"cste", "CSTE\u503c"}, {"cmac", "CMAC\u503c"}, {"cme", "CME\u503c"}, {"exceedLimit", "\u8d85\u9650\u500d\u6570"}, {"pePcTwa", "PE/PC-TWA"}, {"noiseLevel", "\u566a\u58f0\u7b49\u6548\u58f0\u7ea7"}, {"otherFactorValue", "\u5176\u4ed6\u56e0\u7d20\u6d53\u5ea6/\u5f3a\u5ea6"}, {"factorAttrTwa", "\u65f6\u95f4\u52a0\u6743\u5e73\u5747\u5bb9\u8bb8\u6d53\u5ea6"}}) {
            String fieldName = fieldInfo[0];
            String displayName = fieldInfo[1];
            String fieldValue = RiskExposeEvaluateDataUtil.getFieldValue(data, fieldName);
            if (fieldValue == null || fieldValue.trim().isEmpty()) continue;
            fieldJoiner.add(displayName + ":" + fieldValue);
        }
        return fieldJoiner.toString();
    }

    private static String getFieldValue(RiskExposeEvaluateData data, String fieldName) {
        try {
            Field field = ((Object)((Object)data)).getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get((Object)data);
            return value != null ? value.toString() : null;
        }
        catch (Exception e) {
            return RiskExposeEvaluateDataUtil.getFieldValueSafely(data, fieldName);
        }
    }

    private static String getFieldValueSafely(RiskExposeEvaluateData data, String fieldName) {
        switch (fieldName) {
            case "ctwa": {
                return data.getCtwa();
            }
            case "cstel": {
                return data.getCstel();
            }
            case "cste": {
                return data.getCste();
            }
            case "cmac": {
                return data.getCmac();
            }
            case "cme": {
                return data.getCme();
            }
            case "exceedLimit": {
                return data.getExceedLimit();
            }
            case "pePcTwa": {
                return data.getPePcTwa();
            }
            case "reductionFactor": {
                return data.getReductionFactor();
            }
            case "noiseLevel": {
                return data.getNoiseLevel();
            }
            case "otherFactorValue": {
                return data.getOtherFactorValue();
            }
            case "factorAttrTwa": {
                return data.getFactorAttrTwa();
            }
        }
        return null;
    }

    public static void resetSequence() {
        sequenceNumber = 1;
    }
}

