/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UltravioletLightListModel
extends BaseResultListMode {
    private String ultraType;
    private String contactTime;
    private String uw;
    private String mj;
    private String uwEye;
    private String mjEye;
    private String judgedEye;
    private String uwFace;
    private String mjFace;
    private String judgedFace;
    private String uwNone;
    private String mjNone;
    private String judgedNone;

    public static UltravioletLightListModel covert(List<CheckResult> results) {
        UltravioletLightListModel model = new UltravioletLightListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 38) {
                model.setCheckObject(checkValue);
            } else if (targetId == 39) {
                String type = "";
                if ("1".equals(checkValue)) {
                    type = "\u4e2d\u6ce2\u7d2b\u5916\u7ebf";
                } else if ("2".equals(checkValue)) {
                    type = "\u77ed\u6ce2\u7d2b\u5916\u7ebf";
                } else if ("3".equals(checkValue)) {
                    type = "\u7535\u710a\u5f27\u5149";
                }
                model.setUltraType(type);
            } else if (targetId == 40) {
                model.setContactTime(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 41) {
                model.setUw(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 42) {
                model.setMj(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 43) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (targetId == 44) {
                model.setUwEye(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 45) {
                model.setMjEye(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 46) {
                model.setJudgedEye(JudgeStateEnum.getName(checkValue));
            } else if (targetId == 47) {
                model.setUwFace(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 48) {
                model.setMjFace(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 49) {
                model.setJudgedFace(JudgeStateEnum.getName(checkValue));
            } else if (targetId == 50) {
                model.setUwNone(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 51) {
                model.setMjNone(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 52) {
                model.setJudgedNone(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(140).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(141).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(142).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<UltravioletLightListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<UltravioletLightListModel> models = new ArrayList<UltravioletLightListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            UltravioletLightListModel model = UltravioletLightListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getUltraType() {
        return this.ultraType;
    }

    public String getContactTime() {
        return this.contactTime;
    }

    public String getUw() {
        return this.uw;
    }

    public String getMj() {
        return this.mj;
    }

    public String getUwEye() {
        return this.uwEye;
    }

    public String getMjEye() {
        return this.mjEye;
    }

    public String getJudgedEye() {
        return this.judgedEye;
    }

    public String getUwFace() {
        return this.uwFace;
    }

    public String getMjFace() {
        return this.mjFace;
    }

    public String getJudgedFace() {
        return this.judgedFace;
    }

    public String getUwNone() {
        return this.uwNone;
    }

    public String getMjNone() {
        return this.mjNone;
    }

    public String getJudgedNone() {
        return this.judgedNone;
    }

    public void setUltraType(String ultraType) {
        this.ultraType = ultraType;
    }

    public void setContactTime(String contactTime) {
        this.contactTime = contactTime;
    }

    public void setUw(String uw) {
        this.uw = uw;
    }

    public void setMj(String mj) {
        this.mj = mj;
    }

    public void setUwEye(String uwEye) {
        this.uwEye = uwEye;
    }

    public void setMjEye(String mjEye) {
        this.mjEye = mjEye;
    }

    public void setJudgedEye(String judgedEye) {
        this.judgedEye = judgedEye;
    }

    public void setUwFace(String uwFace) {
        this.uwFace = uwFace;
    }

    public void setMjFace(String mjFace) {
        this.mjFace = mjFace;
    }

    public void setJudgedFace(String judgedFace) {
        this.judgedFace = judgedFace;
    }

    public void setUwNone(String uwNone) {
        this.uwNone = uwNone;
    }

    public void setMjNone(String mjNone) {
        this.mjNone = mjNone;
    }

    public void setJudgedNone(String judgedNone) {
        this.judgedNone = judgedNone;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UltravioletLightListModel)) {
            return false;
        }
        UltravioletLightListModel other = (UltravioletLightListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ultraType = this.getUltraType();
        String other$ultraType = other.getUltraType();
        if (this$ultraType == null ? other$ultraType != null : !this$ultraType.equals(other$ultraType)) {
            return false;
        }
        String this$contactTime = this.getContactTime();
        String other$contactTime = other.getContactTime();
        if (this$contactTime == null ? other$contactTime != null : !this$contactTime.equals(other$contactTime)) {
            return false;
        }
        String this$uw = this.getUw();
        String other$uw = other.getUw();
        if (this$uw == null ? other$uw != null : !this$uw.equals(other$uw)) {
            return false;
        }
        String this$mj = this.getMj();
        String other$mj = other.getMj();
        if (this$mj == null ? other$mj != null : !this$mj.equals(other$mj)) {
            return false;
        }
        String this$uwEye = this.getUwEye();
        String other$uwEye = other.getUwEye();
        if (this$uwEye == null ? other$uwEye != null : !this$uwEye.equals(other$uwEye)) {
            return false;
        }
        String this$mjEye = this.getMjEye();
        String other$mjEye = other.getMjEye();
        if (this$mjEye == null ? other$mjEye != null : !this$mjEye.equals(other$mjEye)) {
            return false;
        }
        String this$judgedEye = this.getJudgedEye();
        String other$judgedEye = other.getJudgedEye();
        if (this$judgedEye == null ? other$judgedEye != null : !this$judgedEye.equals(other$judgedEye)) {
            return false;
        }
        String this$uwFace = this.getUwFace();
        String other$uwFace = other.getUwFace();
        if (this$uwFace == null ? other$uwFace != null : !this$uwFace.equals(other$uwFace)) {
            return false;
        }
        String this$mjFace = this.getMjFace();
        String other$mjFace = other.getMjFace();
        if (this$mjFace == null ? other$mjFace != null : !this$mjFace.equals(other$mjFace)) {
            return false;
        }
        String this$judgedFace = this.getJudgedFace();
        String other$judgedFace = other.getJudgedFace();
        if (this$judgedFace == null ? other$judgedFace != null : !this$judgedFace.equals(other$judgedFace)) {
            return false;
        }
        String this$uwNone = this.getUwNone();
        String other$uwNone = other.getUwNone();
        if (this$uwNone == null ? other$uwNone != null : !this$uwNone.equals(other$uwNone)) {
            return false;
        }
        String this$mjNone = this.getMjNone();
        String other$mjNone = other.getMjNone();
        if (this$mjNone == null ? other$mjNone != null : !this$mjNone.equals(other$mjNone)) {
            return false;
        }
        String this$judgedNone = this.getJudgedNone();
        String other$judgedNone = other.getJudgedNone();
        return !(this$judgedNone == null ? other$judgedNone != null : !this$judgedNone.equals(other$judgedNone));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UltravioletLightListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ultraType = this.getUltraType();
        result = result * 59 + ($ultraType == null ? 43 : $ultraType.hashCode());
        String $contactTime = this.getContactTime();
        result = result * 59 + ($contactTime == null ? 43 : $contactTime.hashCode());
        String $uw = this.getUw();
        result = result * 59 + ($uw == null ? 43 : $uw.hashCode());
        String $mj = this.getMj();
        result = result * 59 + ($mj == null ? 43 : $mj.hashCode());
        String $uwEye = this.getUwEye();
        result = result * 59 + ($uwEye == null ? 43 : $uwEye.hashCode());
        String $mjEye = this.getMjEye();
        result = result * 59 + ($mjEye == null ? 43 : $mjEye.hashCode());
        String $judgedEye = this.getJudgedEye();
        result = result * 59 + ($judgedEye == null ? 43 : $judgedEye.hashCode());
        String $uwFace = this.getUwFace();
        result = result * 59 + ($uwFace == null ? 43 : $uwFace.hashCode());
        String $mjFace = this.getMjFace();
        result = result * 59 + ($mjFace == null ? 43 : $mjFace.hashCode());
        String $judgedFace = this.getJudgedFace();
        result = result * 59 + ($judgedFace == null ? 43 : $judgedFace.hashCode());
        String $uwNone = this.getUwNone();
        result = result * 59 + ($uwNone == null ? 43 : $uwNone.hashCode());
        String $mjNone = this.getMjNone();
        result = result * 59 + ($mjNone == null ? 43 : $mjNone.hashCode());
        String $judgedNone = this.getJudgedNone();
        result = result * 59 + ($judgedNone == null ? 43 : $judgedNone.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UltravioletLightListModel(ultraType=" + this.getUltraType() + ", contactTime=" + this.getContactTime() + ", uw=" + this.getUw() + ", mj=" + this.getMj() + ", uwEye=" + this.getUwEye() + ", mjEye=" + this.getMjEye() + ", judgedEye=" + this.getJudgedEye() + ", uwFace=" + this.getUwFace() + ", mjFace=" + this.getMjFace() + ", judgedFace=" + this.getJudgedFace() + ", uwNone=" + this.getUwNone() + ", mjNone=" + this.getMjNone() + ", judgedNone=" + this.getJudgedNone() + ")";
    }
}

