/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UltrahighFrequencyRadiationListModel
extends BaseResultListMode {
    private String type;
    private String hour;
    private String mw;
    private String powerLevel;

    public static UltrahighFrequencyRadiationListModel covert(List<CheckResult> results) {
        UltrahighFrequencyRadiationListModel model = new UltrahighFrequencyRadiationListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 70) {
                model.setCheckObject(checkValue);
            } else if (targetId == 71) {
                model.setType(checkValue);
            } else if (targetId == 72) {
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 73) {
                model.setMw(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 74) {
                model.setPowerLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 75) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(156).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(157).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(158).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<UltrahighFrequencyRadiationListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<UltrahighFrequencyRadiationListModel> models = new ArrayList<UltrahighFrequencyRadiationListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            UltrahighFrequencyRadiationListModel model = UltrahighFrequencyRadiationListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getType() {
        return this.type;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMw() {
        return this.mw;
    }

    public String getPowerLevel() {
        return this.powerLevel;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public void setMw(String mw) {
        this.mw = mw;
    }

    public void setPowerLevel(String powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UltrahighFrequencyRadiationListModel)) {
            return false;
        }
        UltrahighFrequencyRadiationListModel other = (UltrahighFrequencyRadiationListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$hour = this.getHour();
        String other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !this$hour.equals(other$hour)) {
            return false;
        }
        String this$mw = this.getMw();
        String other$mw = other.getMw();
        if (this$mw == null ? other$mw != null : !this$mw.equals(other$mw)) {
            return false;
        }
        String this$powerLevel = this.getPowerLevel();
        String other$powerLevel = other.getPowerLevel();
        return !(this$powerLevel == null ? other$powerLevel != null : !this$powerLevel.equals(other$powerLevel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UltrahighFrequencyRadiationListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : $hour.hashCode());
        String $mw = this.getMw();
        result = result * 59 + ($mw == null ? 43 : $mw.hashCode());
        String $powerLevel = this.getPowerLevel();
        result = result * 59 + ($powerLevel == null ? 43 : $powerLevel.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UltrahighFrequencyRadiationListModel(type=" + this.getType() + ", hour=" + this.getHour() + ", mw=" + this.getMw() + ", powerLevel=" + this.getPowerLevel() + ")";
    }
}

