/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.util.CollectionUtils;

public class ResultUtils {
    public static Map<Long, List<CheckResult>> splitByRowNum(List<CheckResult> results) {
        TreeMap<Long, List<CheckResult>> resultRowMap = new TreeMap<Long, List<CheckResult>>();
        if (CollectionUtils.isEmpty(results)) {
            return resultRowMap;
        }
        results.forEach(l -> {
            Long rowNum = l.getResultNo();
            List<CheckResult> rowList = resultRowMap.get(rowNum) == null ? new ArrayList() : (List)resultRowMap.get(rowNum);
            rowList.add((CheckResult)((Object)l));
            resultRowMap.put(rowNum, rowList);
        });
        return resultRowMap;
    }

    public static boolean isNotEmpty(String str) {
        if (str == null) {
            return false;
        }
        return !(str = str.trim()).equals("");
    }

    public static String getBiologicalUnit(String harmId, String unit) {
        if ("596".equals(harmId)) {
            return "\u5b62\u5b50\u6570/m\u00b3";
        }
        if ("597".equals(harmId)) {
            return "ng/m\u00b3";
        }
        if (unit == null) {
            return "";
        }
        return unit;
    }

    public static String getRange(Integer rangeType, String min, String max) {
        String s = "";
        if (rangeType != null) {
            if (rangeType.equals(2)) {
                s = s + "<";
            } else if (rangeType.equals(3)) {
                s = s + "\u2264";
            }
        }
        if (min != null && min.length() > 0 && max != null && max.length() > 0) {
            s = min.equals(max) ? s + " " + min : s + " " + min + "~" + max;
            return s;
        }
        if ((min == null || min.isEmpty()) && (max == null || max.isEmpty())) {
            return "";
        }
        if (min == null || min.isEmpty()) {
            s = s + " " + max;
            return s;
        }
        return s + " " + min;
    }

    public static String[] getRadiationArr(String radiations) {
        String[] arr1 = new String[4];
        if (!ResultUtils.isNotEmpty(radiations)) {
            return arr1;
        }
        String[] arr = radiations.split(",");
        if (arr.length < 4) {
            int i;
            for (i = 0; i < arr.length; ++i) {
                arr1[i] = arr[i];
            }
            for (i = arr.length; i < 4; ++i) {
                arr1[i] = "";
            }
        } else {
            arr1 = arr;
        }
        return arr1;
    }

    public static String getRadiation(Integer rangeType, String radiations) {
        String[] arr1 = ResultUtils.getRadiationArr(radiations);
        String exposure = "";
        if (rangeType != null) {
            if (rangeType.equals(2)) {
                exposure = exposure + "<";
            } else if (rangeType.equals(3)) {
                exposure = exposure + "\u2264";
            }
        }
        if (ResultUtils.isNotEmpty(arr1[0])) {
            exposure = exposure + arr1[0];
        }
        if (ResultUtils.isNotEmpty(arr1[1])) {
            exposure = exposure + "\u00d710" + ResultUtils.getSuperscript(arr1[1]);
        }
        if (ResultUtils.isNotEmpty(exposure) && (ResultUtils.isNotEmpty(arr1[2]) || ResultUtils.isNotEmpty(arr1[3]))) {
            exposure = exposure + "~";
        }
        if (ResultUtils.isNotEmpty(arr1[2])) {
            exposure = exposure + arr1[2];
        }
        if (ResultUtils.isNotEmpty(arr1[3])) {
            exposure = exposure + "\u00d710" + ResultUtils.getSuperscript(arr1[3]);
        }
        return exposure;
    }

    public static String getType1(String type) {
        if ("1".equals(type)) {
            return "\u5168\u8eab\u8f90\u5c04";
        }
        if ("2".equals(type)) {
            return "\u5c40\u90e8\u8f90\u5c04";
        }
        return "";
    }

    public static String getType2(String type) {
        if ("1".equals(type)) {
            return "\u8fde\u7eed\u5fae\u6ce2";
        }
        if ("2".equals(type)) {
            return "\u8109\u51b2\u5fae\u6ce2";
        }
        return "";
    }

    public static String getNoiseType(String type) {
        if ("1".equals(type)) {
            return "\u4e2a\u4f53";
        }
        if ("2".equals(type)) {
            return "\u7a33\u6001\u566a\u58f0";
        }
        if ("3".equals(type)) {
            return "\u975e\u7a33\u6001\u566a\u58f0";
        }
        if ("4".equals(type)) {
            return "\u8109\u51b2\u566a\u58f0";
        }
        return "";
    }

    public static String getSuperscript(String numChar) {
        try {
            StringBuilder minus = new StringBuilder();
            String superscripts = "\u00ba\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079";
            for (int a = 0; a < numChar.length(); ++a) {
                char c = numChar.charAt(a);
                if (c == '.') {
                    minus.append("\u02d9");
                    continue;
                }
                if (c == '-') {
                    minus.append("\u207b");
                    continue;
                }
                minus.append(superscripts.charAt(Integer.parseInt(c + "")));
            }
            return minus.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

