/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class NoiseListModel
extends BaseResultListMode {
    private String noiseType;
    private String checkedNum;
    private String minNum;
    private String maxNum;
    private String level;
    private String times;
    private String peak;

    public static NoiseListModel covert(List<CheckResult> results) {
        NoiseListModel model = new NoiseListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 24) {
                model.setCheckObject(checkValue);
            } else if (targetId == 25) {
                model.setNoiseType(ResultUtils.getNoiseType(checkValue));
            } else if (targetId == 26) {
                model.setCheckedNum(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 27) {
                model.setMinNum(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 28) {
                model.setMaxNum(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 29) {
                model.setLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 30) {
                model.setTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 31) {
                model.setPeak(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 32) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(132).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(133).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(134).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<NoiseListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<NoiseListModel> models = new ArrayList<NoiseListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            NoiseListModel model = NoiseListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getNoiseType() {
        return this.noiseType;
    }

    public String getCheckedNum() {
        return this.checkedNum;
    }

    public String getMinNum() {
        return this.minNum;
    }

    public String getMaxNum() {
        return this.maxNum;
    }

    public String getLevel() {
        return this.level;
    }

    public String getTimes() {
        return this.times;
    }

    public String getPeak() {
        return this.peak;
    }

    public void setNoiseType(String noiseType) {
        this.noiseType = noiseType;
    }

    public void setCheckedNum(String checkedNum) {
        this.checkedNum = checkedNum;
    }

    public void setMinNum(String minNum) {
        this.minNum = minNum;
    }

    public void setMaxNum(String maxNum) {
        this.maxNum = maxNum;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setTimes(String times) {
        this.times = times;
    }

    public void setPeak(String peak) {
        this.peak = peak;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoiseListModel)) {
            return false;
        }
        NoiseListModel other = (NoiseListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$noiseType = this.getNoiseType();
        String other$noiseType = other.getNoiseType();
        if (this$noiseType == null ? other$noiseType != null : !this$noiseType.equals(other$noiseType)) {
            return false;
        }
        String this$checkedNum = this.getCheckedNum();
        String other$checkedNum = other.getCheckedNum();
        if (this$checkedNum == null ? other$checkedNum != null : !this$checkedNum.equals(other$checkedNum)) {
            return false;
        }
        String this$minNum = this.getMinNum();
        String other$minNum = other.getMinNum();
        if (this$minNum == null ? other$minNum != null : !this$minNum.equals(other$minNum)) {
            return false;
        }
        String this$maxNum = this.getMaxNum();
        String other$maxNum = other.getMaxNum();
        if (this$maxNum == null ? other$maxNum != null : !this$maxNum.equals(other$maxNum)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$times = this.getTimes();
        String other$times = other.getTimes();
        if (this$times == null ? other$times != null : !this$times.equals(other$times)) {
            return false;
        }
        String this$peak = this.getPeak();
        String other$peak = other.getPeak();
        return !(this$peak == null ? other$peak != null : !this$peak.equals(other$peak));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NoiseListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $noiseType = this.getNoiseType();
        result = result * 59 + ($noiseType == null ? 43 : $noiseType.hashCode());
        String $checkedNum = this.getCheckedNum();
        result = result * 59 + ($checkedNum == null ? 43 : $checkedNum.hashCode());
        String $minNum = this.getMinNum();
        result = result * 59 + ($minNum == null ? 43 : $minNum.hashCode());
        String $maxNum = this.getMaxNum();
        result = result * 59 + ($maxNum == null ? 43 : $maxNum.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : $times.hashCode());
        String $peak = this.getPeak();
        result = result * 59 + ($peak == null ? 43 : $peak.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NoiseListModel(noiseType=" + this.getNoiseType() + ", checkedNum=" + this.getCheckedNum() + ", minNum=" + this.getMinNum() + ", maxNum=" + this.getMaxNum() + ", level=" + this.getLevel() + ", times=" + this.getTimes() + ", peak=" + this.getPeak() + ")";
    }
}

