/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class MicrowaveRadiationListModel
extends BaseResultListMode {
    private String type1;
    private String type2;
    private String hour;
    private String daliy;
    private String avg;
    private String mw;

    public static MicrowaveRadiationListModel covert(List<CheckResult> results) {
        MicrowaveRadiationListModel model = new MicrowaveRadiationListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 57) {
                model.setCheckObject(checkValue);
            } else if (targetId == 58) {
                String[] types = checkValue.split(",");
                int typesLength = types.length;
                for (int i = 0; i < typesLength; ++i) {
                    String type = types[i];
                    if (i == 0) {
                        model.setType1(ResultUtils.getType1(type));
                    }
                    if (i != 1) continue;
                    model.setType2(ResultUtils.getType2(type));
                }
            } else if (targetId == 59) {
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 60) {
                model.setDaliy(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 61) {
                model.setAvg(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 62) {
                model.setMw(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 63) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(148).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(149).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(150).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<MicrowaveRadiationListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<MicrowaveRadiationListModel> models = new ArrayList<MicrowaveRadiationListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            MicrowaveRadiationListModel model = MicrowaveRadiationListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getType1() {
        return this.type1;
    }

    public String getType2() {
        return this.type2;
    }

    public String getHour() {
        return this.hour;
    }

    public String getDaliy() {
        return this.daliy;
    }

    public String getAvg() {
        return this.avg;
    }

    public String getMw() {
        return this.mw;
    }

    public void setType1(String type1) {
        this.type1 = type1;
    }

    public void setType2(String type2) {
        this.type2 = type2;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public void setDaliy(String daliy) {
        this.daliy = daliy;
    }

    public void setAvg(String avg) {
        this.avg = avg;
    }

    public void setMw(String mw) {
        this.mw = mw;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicrowaveRadiationListModel)) {
            return false;
        }
        MicrowaveRadiationListModel other = (MicrowaveRadiationListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type1 = this.getType1();
        String other$type1 = other.getType1();
        if (this$type1 == null ? other$type1 != null : !this$type1.equals(other$type1)) {
            return false;
        }
        String this$type2 = this.getType2();
        String other$type2 = other.getType2();
        if (this$type2 == null ? other$type2 != null : !this$type2.equals(other$type2)) {
            return false;
        }
        String this$hour = this.getHour();
        String other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !this$hour.equals(other$hour)) {
            return false;
        }
        String this$daliy = this.getDaliy();
        String other$daliy = other.getDaliy();
        if (this$daliy == null ? other$daliy != null : !this$daliy.equals(other$daliy)) {
            return false;
        }
        String this$avg = this.getAvg();
        String other$avg = other.getAvg();
        if (this$avg == null ? other$avg != null : !this$avg.equals(other$avg)) {
            return false;
        }
        String this$mw = this.getMw();
        String other$mw = other.getMw();
        return !(this$mw == null ? other$mw != null : !this$mw.equals(other$mw));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MicrowaveRadiationListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type1 = this.getType1();
        result = result * 59 + ($type1 == null ? 43 : $type1.hashCode());
        String $type2 = this.getType2();
        result = result * 59 + ($type2 == null ? 43 : $type2.hashCode());
        String $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : $hour.hashCode());
        String $daliy = this.getDaliy();
        result = result * 59 + ($daliy == null ? 43 : $daliy.hashCode());
        String $avg = this.getAvg();
        result = result * 59 + ($avg == null ? 43 : $avg.hashCode());
        String $mw = this.getMw();
        result = result * 59 + ($mw == null ? 43 : $mw.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MicrowaveRadiationListModel(type1=" + this.getType1() + ", type2=" + this.getType2() + ", hour=" + this.getHour() + ", daliy=" + this.getDaliy() + ", avg=" + this.getAvg() + ", mw=" + this.getMw() + ")";
    }
}

