/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class LaserRadiationListModel
extends BaseResultListMode {
    private String position;
    private String hour;
    private String range;
    private String len;
    private String time;
    private String j;
    private String w;

    public static LaserRadiationListModel covert(List<CheckResult> results) {
        LaserRadiationListModel model = new LaserRadiationListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 88) {
                model.setCheckObject(checkValue);
            } else if (targetId == 89) {
                model.setPosition(checkValue);
            } else if (targetId == 90) {
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 91) {
                model.setRange(checkValue);
            } else if (targetId == 92) {
                model.setLen(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 93) {
                model.setTime(ResultUtils.getRadiation(l.getCheckValueRangeType(), checkValue));
            } else if (targetId == 94) {
                model.setJ(ResultUtils.getRadiation(l.getCheckValueRangeType(), checkValue));
            } else if (targetId == 95) {
                model.setW(ResultUtils.getRadiation(l.getCheckValueRangeType(), checkValue));
            } else if (targetId == 96) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(168).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(169).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(170).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<LaserRadiationListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<LaserRadiationListModel> models = new ArrayList<LaserRadiationListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            LaserRadiationListModel model = LaserRadiationListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getPosition() {
        return this.position;
    }

    public String getHour() {
        return this.hour;
    }

    public String getRange() {
        return this.range;
    }

    public String getLen() {
        return this.len;
    }

    public String getTime() {
        return this.time;
    }

    public String getJ() {
        return this.j;
    }

    public String getW() {
        return this.w;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public void setLen(String len) {
        this.len = len;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setJ(String j) {
        this.j = j;
    }

    public void setW(String w) {
        this.w = w;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LaserRadiationListModel)) {
            return false;
        }
        LaserRadiationListModel other = (LaserRadiationListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$hour = this.getHour();
        String other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !this$hour.equals(other$hour)) {
            return false;
        }
        String this$range = this.getRange();
        String other$range = other.getRange();
        if (this$range == null ? other$range != null : !this$range.equals(other$range)) {
            return false;
        }
        String this$len = this.getLen();
        String other$len = other.getLen();
        if (this$len == null ? other$len != null : !this$len.equals(other$len)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        String this$j = this.getJ();
        String other$j = other.getJ();
        if (this$j == null ? other$j != null : !this$j.equals(other$j)) {
            return false;
        }
        String this$w = this.getW();
        String other$w = other.getW();
        return !(this$w == null ? other$w != null : !this$w.equals(other$w));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LaserRadiationListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : $hour.hashCode());
        String $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        String $len = this.getLen();
        result = result * 59 + ($len == null ? 43 : $len.hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        String $j = this.getJ();
        result = result * 59 + ($j == null ? 43 : $j.hashCode());
        String $w = this.getW();
        result = result * 59 + ($w == null ? 43 : $w.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LaserRadiationListModel(position=" + this.getPosition() + ", hour=" + this.getHour() + ", range=" + this.getRange() + ", len=" + this.getLen() + ", time=" + this.getTime() + ", j=" + this.getJ() + ", w=" + this.getW() + ")";
    }
}

