/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class IonizingRadiationListModel
extends BaseResultListMode {
    private String position;
    private Integer checkResultType;
    private String checkResult;
    private String deviceOrSourceId;

    public static IonizingRadiationListModel covert(List<CheckResult> results) {
        IonizingRadiationListModel model = new IonizingRadiationListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 77 || targetId == 81) {
                model.setPosition(checkValue);
            } else if (targetId == 76 || targetId == 80) {
                model.setDeviceOrSourceId(checkValue);
            } else if (targetId == 78 || targetId == 82) {
                model.setCheckResultType(l.getCheckValueRangeType());
                model.setCheckResult(l.getCheckValueMin());
            } else if (targetId == 79 || targetId == 83) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(160).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(161).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(162).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<IonizingRadiationListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<IonizingRadiationListModel> models = new ArrayList<IonizingRadiationListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            IonizingRadiationListModel model = IonizingRadiationListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getPosition() {
        return this.position;
    }

    public Integer getCheckResultType() {
        return this.checkResultType;
    }

    public String getCheckResult() {
        return this.checkResult;
    }

    public String getDeviceOrSourceId() {
        return this.deviceOrSourceId;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setCheckResultType(Integer checkResultType) {
        this.checkResultType = checkResultType;
    }

    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    public void setDeviceOrSourceId(String deviceOrSourceId) {
        this.deviceOrSourceId = deviceOrSourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IonizingRadiationListModel)) {
            return false;
        }
        IonizingRadiationListModel other = (IonizingRadiationListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$checkResultType = this.getCheckResultType();
        Integer other$checkResultType = other.getCheckResultType();
        if (this$checkResultType == null ? other$checkResultType != null : !((Object)this$checkResultType).equals(other$checkResultType)) {
            return false;
        }
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$checkResult = this.getCheckResult();
        String other$checkResult = other.getCheckResult();
        if (this$checkResult == null ? other$checkResult != null : !this$checkResult.equals(other$checkResult)) {
            return false;
        }
        String this$deviceOrSourceId = this.getDeviceOrSourceId();
        String other$deviceOrSourceId = other.getDeviceOrSourceId();
        return !(this$deviceOrSourceId == null ? other$deviceOrSourceId != null : !this$deviceOrSourceId.equals(other$deviceOrSourceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IonizingRadiationListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $checkResultType = this.getCheckResultType();
        result = result * 59 + ($checkResultType == null ? 43 : ((Object)$checkResultType).hashCode());
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $checkResult = this.getCheckResult();
        result = result * 59 + ($checkResult == null ? 43 : $checkResult.hashCode());
        String $deviceOrSourceId = this.getDeviceOrSourceId();
        result = result * 59 + ($deviceOrSourceId == null ? 43 : $deviceOrSourceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "IonizingRadiationListModel(position=" + this.getPosition() + ", checkResultType=" + this.getCheckResultType() + ", checkResult=" + this.getCheckResult() + ", deviceOrSourceId=" + this.getDeviceOrSourceId() + ")";
    }
}

