/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class IlluminancyListModel
extends BaseResultListMode {
    private String checkResult;

    public static IlluminancyListModel covert(List<CheckResult> results) {
        IlluminancyListModel model = new IlluminancyListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 105) {
                model.setCheckObject(checkValue);
            } else if (targetId == 106) {
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 107) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(176).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(177).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(178).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<IlluminancyListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<IlluminancyListModel> models = new ArrayList<IlluminancyListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            IlluminancyListModel model = IlluminancyListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getCheckResult() {
        return this.checkResult;
    }

    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IlluminancyListModel)) {
            return false;
        }
        IlluminancyListModel other = (IlluminancyListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$checkResult = this.getCheckResult();
        String other$checkResult = other.getCheckResult();
        return !(this$checkResult == null ? other$checkResult != null : !this$checkResult.equals(other$checkResult));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IlluminancyListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $checkResult = this.getCheckResult();
        result = result * 59 + ($checkResult == null ? 43 : $checkResult.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "IlluminancyListModel(checkResult=" + this.getCheckResult() + ")";
    }
}

