/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class HighTemperatureListModel
extends BaseResultListMode {
    private String contactRate;
    private String strength;
    private String checkResult;

    public static HighTemperatureListModel covert(List<CheckResult> results) {
        HighTemperatureListModel model = new HighTemperatureListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 33) {
                model.setCheckObject(checkValue);
            } else if (targetId == 34) {
                model.setContactRate(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 35) {
                model.setStrength(HighTemperatureListModel.getValue35(checkValue));
            } else if (targetId == 36) {
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 37) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(136).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(137).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(138).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<HighTemperatureListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<HighTemperatureListModel> models = new ArrayList<HighTemperatureListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            HighTemperatureListModel model = HighTemperatureListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    private static String getValue35(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u2160";
            }
            case "2": {
                return "\u2161";
            }
            case "3": {
                return "\u2162";
            }
            case "4": {
                return "\u2163";
            }
        }
        return "";
    }

    public String getContactRate() {
        return this.contactRate;
    }

    public String getStrength() {
        return this.strength;
    }

    public String getCheckResult() {
        return this.checkResult;
    }

    public void setContactRate(String contactRate) {
        this.contactRate = contactRate;
    }

    public void setStrength(String strength) {
        this.strength = strength;
    }

    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HighTemperatureListModel)) {
            return false;
        }
        HighTemperatureListModel other = (HighTemperatureListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contactRate = this.getContactRate();
        String other$contactRate = other.getContactRate();
        if (this$contactRate == null ? other$contactRate != null : !this$contactRate.equals(other$contactRate)) {
            return false;
        }
        String this$strength = this.getStrength();
        String other$strength = other.getStrength();
        if (this$strength == null ? other$strength != null : !this$strength.equals(other$strength)) {
            return false;
        }
        String this$checkResult = this.getCheckResult();
        String other$checkResult = other.getCheckResult();
        return !(this$checkResult == null ? other$checkResult != null : !this$checkResult.equals(other$checkResult));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HighTemperatureListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contactRate = this.getContactRate();
        result = result * 59 + ($contactRate == null ? 43 : $contactRate.hashCode());
        String $strength = this.getStrength();
        result = result * 59 + ($strength == null ? 43 : $strength.hashCode());
        String $checkResult = this.getCheckResult();
        result = result * 59 + ($checkResult == null ? 43 : $checkResult.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HighTemperatureListModel(contactRate=" + this.getContactRate() + ", strength=" + this.getStrength() + ", checkResult=" + this.getCheckResult() + ")";
    }
}

