/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class HandTranSmittedListModel
extends BaseResultListMode {
    private String hour;
    private String speed;

    public static HandTranSmittedListModel covert(List<CheckResult> results) {
        HandTranSmittedListModel model = new HandTranSmittedListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 84) {
                model.setCheckObject(checkValue);
            } else if (targetId == 85) {
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 86) {
                model.setSpeed(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 87) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(164).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(165).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(166).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<HandTranSmittedListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<HandTranSmittedListModel> models = new ArrayList<HandTranSmittedListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            HandTranSmittedListModel model = HandTranSmittedListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getHour() {
        return this.hour;
    }

    public String getSpeed() {
        return this.speed;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public void setSpeed(String speed) {
        this.speed = speed;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandTranSmittedListModel)) {
            return false;
        }
        HandTranSmittedListModel other = (HandTranSmittedListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hour = this.getHour();
        String other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !this$hour.equals(other$hour)) {
            return false;
        }
        String this$speed = this.getSpeed();
        String other$speed = other.getSpeed();
        return !(this$speed == null ? other$speed != null : !this$speed.equals(other$speed));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HandTranSmittedListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : $hour.hashCode());
        String $speed = this.getSpeed();
        result = result * 59 + ($speed == null ? 43 : $speed.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HandTranSmittedListModel(hour=" + this.getHour() + ", speed=" + this.getSpeed() + ")";
    }
}

