/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class FreshAirRateListModel
extends BaseResultListMode {
    private String isDirty;
    private String checkResult;
    private String num;
    private String avg;

    public static FreshAirRateListModel covert(List<CheckResult> results) {
        FreshAirRateListModel model = new FreshAirRateListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 115) {
                model.setCheckObject(checkValue);
            } else if (targetId == 116) {
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 117) {
                if ("1".equals(checkValue)) {
                    model.setIsDirty("\u662f");
                } else if ("2".equals(checkValue)) {
                    model.setIsDirty("\u5426");
                }
            } else if (targetId == 118) {
                model.setNum(checkValue);
            } else if (targetId == 119) {
                model.setAvg(checkValue);
            } else if (targetId == 120) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(187).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(184).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(185).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }

    public static List<FreshAirRateListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap) {
        ArrayList<FreshAirRateListModel> models = new ArrayList<FreshAirRateListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            FreshAirRateListModel model = FreshAirRateListModel.covert(rowList);
            models.add(model);
        }
        return models;
    }

    public String getIsDirty() {
        return this.isDirty;
    }

    public String getCheckResult() {
        return this.checkResult;
    }

    public String getNum() {
        return this.num;
    }

    public String getAvg() {
        return this.avg;
    }

    public void setIsDirty(String isDirty) {
        this.isDirty = isDirty;
    }

    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setAvg(String avg) {
        this.avg = avg;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreshAirRateListModel)) {
            return false;
        }
        FreshAirRateListModel other = (FreshAirRateListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$isDirty = this.getIsDirty();
        String other$isDirty = other.getIsDirty();
        if (this$isDirty == null ? other$isDirty != null : !this$isDirty.equals(other$isDirty)) {
            return false;
        }
        String this$checkResult = this.getCheckResult();
        String other$checkResult = other.getCheckResult();
        if (this$checkResult == null ? other$checkResult != null : !this$checkResult.equals(other$checkResult)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$avg = this.getAvg();
        String other$avg = other.getAvg();
        return !(this$avg == null ? other$avg != null : !this$avg.equals(other$avg));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FreshAirRateListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $isDirty = this.getIsDirty();
        result = result * 59 + ($isDirty == null ? 43 : $isDirty.hashCode());
        String $checkResult = this.getCheckResult();
        result = result * 59 + ($checkResult == null ? 43 : $checkResult.hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $avg = this.getAvg();
        result = result * 59 + ($avg == null ? 43 : $avg.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FreshAirRateListModel(isDirty=" + this.getIsDirty() + ", checkResult=" + this.getCheckResult() + ", num=" + this.getNum() + ", avg=" + this.getAvg() + ")";
    }
}

