/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class ChemicalListModel
extends BaseResultListMode {
    private String me;
    private String mac;
    private String twa;
    private String ste;
    private String stel;
    private String peakCon;
    private String overTimes;
    private String reductionFactor;

    public static ChemicalListModel covert(List<CheckResult> results, Map<String, String> allHarmMap) {
        ChemicalListModel model = new ChemicalListModel();
        results.forEach(l -> {
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            model.setSourceId(l.getSourceId());
            model.setSourceCheckId(l.getSourceCheckId());
            model.setItemOpState(l.getItemOpState());
            model.setOldItemId(l.getOldItemId());
            model.setReason(l.getReason());
            model.setCreateDate(l.getCreateDate());
            model.setIsRisk(l.getIsRisk());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if (targetId == 1) {
                model.setCheckObject(checkValue);
            } else if (targetId == 2) {
                String s = (String)allHarmMap.get(checkValue);
                if (s != null) {
                    model.setCheckProject(s);
                    model.setHarmId(checkValue);
                } else {
                    model.setCheckProject(checkValue);
                    model.setHarmId("");
                }
            } else if (targetId == 3) {
                model.setTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 4) {
                model.setStel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 5) {
                model.setMac(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 6) {
                model.setMe(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 7) {
                model.setSte(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 8) {
                model.setPeakCon(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 9) {
                model.setOverTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            } else if (targetId == 10) {
                model.setJudged(JudgeStateEnum.getName(checkValue));
            } else if (Integer.valueOf(124).equals(targetId)) {
                model.setWorkshopName(checkValue);
            } else if (Integer.valueOf(125).equals(targetId)) {
                model.setWorkName(checkValue);
            } else if (Integer.valueOf(126).equals(targetId) && NumberUtil.isDigits((String)checkValue)) {
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            } else if (Integer.valueOf(192).equals(targetId)) {
                model.setReductionFactor(checkValue);
            }
        });
        return model;
    }

    public static List<ChemicalListModel> covertMap(Map<Long, List<CheckResult>> resultRowMap, Map<String, String> allHarmMap) {
        ArrayList<ChemicalListModel> models = new ArrayList<ChemicalListModel>();
        if (CollectionUtils.isEmpty(resultRowMap)) {
            return models;
        }
        for (Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()) {
            List<CheckResult> rowList = entry.getValue();
            ChemicalListModel model = ChemicalListModel.covert(rowList, allHarmMap);
            models.add(model);
        }
        return models;
    }

    public String getMe() {
        return this.me;
    }

    public String getMac() {
        return this.mac;
    }

    public String getTwa() {
        return this.twa;
    }

    public String getSte() {
        return this.ste;
    }

    public String getStel() {
        return this.stel;
    }

    public String getPeakCon() {
        return this.peakCon;
    }

    public String getOverTimes() {
        return this.overTimes;
    }

    public String getReductionFactor() {
        return this.reductionFactor;
    }

    public void setMe(String me) {
        this.me = me;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setTwa(String twa) {
        this.twa = twa;
    }

    public void setSte(String ste) {
        this.ste = ste;
    }

    public void setStel(String stel) {
        this.stel = stel;
    }

    public void setPeakCon(String peakCon) {
        this.peakCon = peakCon;
    }

    public void setOverTimes(String overTimes) {
        this.overTimes = overTimes;
    }

    public void setReductionFactor(String reductionFactor) {
        this.reductionFactor = reductionFactor;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChemicalListModel)) {
            return false;
        }
        ChemicalListModel other = (ChemicalListModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$me = this.getMe();
        String other$me = other.getMe();
        if (this$me == null ? other$me != null : !this$me.equals(other$me)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$twa = this.getTwa();
        String other$twa = other.getTwa();
        if (this$twa == null ? other$twa != null : !this$twa.equals(other$twa)) {
            return false;
        }
        String this$ste = this.getSte();
        String other$ste = other.getSte();
        if (this$ste == null ? other$ste != null : !this$ste.equals(other$ste)) {
            return false;
        }
        String this$stel = this.getStel();
        String other$stel = other.getStel();
        if (this$stel == null ? other$stel != null : !this$stel.equals(other$stel)) {
            return false;
        }
        String this$peakCon = this.getPeakCon();
        String other$peakCon = other.getPeakCon();
        if (this$peakCon == null ? other$peakCon != null : !this$peakCon.equals(other$peakCon)) {
            return false;
        }
        String this$overTimes = this.getOverTimes();
        String other$overTimes = other.getOverTimes();
        if (this$overTimes == null ? other$overTimes != null : !this$overTimes.equals(other$overTimes)) {
            return false;
        }
        String this$reductionFactor = this.getReductionFactor();
        String other$reductionFactor = other.getReductionFactor();
        return !(this$reductionFactor == null ? other$reductionFactor != null : !this$reductionFactor.equals(other$reductionFactor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChemicalListModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $me = this.getMe();
        result = result * 59 + ($me == null ? 43 : $me.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $twa = this.getTwa();
        result = result * 59 + ($twa == null ? 43 : $twa.hashCode());
        String $ste = this.getSte();
        result = result * 59 + ($ste == null ? 43 : $ste.hashCode());
        String $stel = this.getStel();
        result = result * 59 + ($stel == null ? 43 : $stel.hashCode());
        String $peakCon = this.getPeakCon();
        result = result * 59 + ($peakCon == null ? 43 : $peakCon.hashCode());
        String $overTimes = this.getOverTimes();
        result = result * 59 + ($overTimes == null ? 43 : $overTimes.hashCode());
        String $reductionFactor = this.getReductionFactor();
        result = result * 59 + ($reductionFactor == null ? 43 : $reductionFactor.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ChemicalListModel(me=" + this.getMe() + ", mac=" + this.getMac() + ", twa=" + this.getTwa() + ", ste=" + this.getSte() + ", stel=" + this.getStel() + ", peakCon=" + this.getPeakCon() + ", overTimes=" + this.getOverTimes() + ", reductionFactor=" + this.getReductionFactor() + ")";
    }
}

