/*下标:
ᴀʙᴄᴅᴇғɢʜɪᴊᴋʟᴍɴᴏᴘǫʀsᴛᴜᴠᴡxʏᴢ
常用上标 º¹²³⁴⁵⁶⁷⁸⁹⁺⁻⁼⁽⁾ⁿ˙ 常用下标 ₀₁₂₃₄₅₆₇₈₉₊₋
*/
/*数据库:
 create database hazard_factor_inspection default charset utf8mb4;
 use hazard_factor_inspection;
*/

/*指标标准表（有固定数据）*/
DROP TABLE IF EXISTS `check_target_standard`;
CREATE TABLE `check_target_standard` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(512) NOT NULL COMMENT '标准名称',
  `start_date` datetime default null COMMENT '有效期开始（为null表示无时间限制）',
  `end_date` datetime default null COMMENT '有效期结束（为null表示无时间限制）',
  `description` varchar(1024) default null comment '说明',
   is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
   create_by   bigint unsigned     not null default 0 comment '创建人',
   create_date datetime             null   comment '创建时间',
   update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
   update_date datetime             null  comment '最后修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='指标标准表';

/*检测类型表*/
DROP TABLE IF EXISTS `hc_check_type`;
CREATE TABLE `hc_check_type` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `check_type_name` varchar(32) NOT NULL COMMENT '类型名称',
   `cid` bigint default 0 comment '企业id',
  `description` varchar(1024) default null comment '说明',
   is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
   create_by   bigint unsigned     not null default 0 comment '创建人',
   create_date datetime             null   comment '创建时间',
   update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
   update_date datetime             null  comment '最后修改时间',
   check_type_flag tinyint          null comment '类型标识（1:日常,2:定期,3:现状,4:控评,5:自定义）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='检测类型表';


/*检测表*/
drop table  check_plan;
create table check_plan
(
    id                                bigint unsigned default 0 not null comment 'id'
        primary key,
    target_standard_id                bigint unsigned           default 2 comment '检测项检测指标使用的标准id（check_target_standard表）',
    cid                               bigint unsigned           null comment '企业id',
    check_work_no                     varchar(64)               null comment '工作编号',
    check_work_name                   varchar(512)              null comment '检测工作名称',
    check_date_begin                  datetime                      null comment '检测开始日期',
    check_date_end                    datetime                      null comment '检测结束日期',
    check_type                        bigint unsigned           null comment '检测类型id(hc_check_type表)',
    check_from                        int                       null comment '来自哪里(1:企业端 2：机构端)',
    manager                           bigint unsigned           null comment '测负责人（来自企业端）',
    check_service_type                tinyint         default 0 null comment '检测服务类型， 0 委外检测； 1 自行检测',
    third_org_id                      bigint unsigned           null comment '委外检测的第三方机构id',
    dept_id                           bigint unsigned           null comment '自行检测的部门id',
    check_report_name                 varchar(512)         		null comment '检测报告名称',
	check_report_location             varchar(512)               null comment '原件存放位置（检测报告）',
	check_report_file_ids             varchar(1024)             null comment '检测报告(文件id)',
    contract_location                 varchar(512)              null comment '检测委托书/合同原件存放位置',
	contract_file_ids                 varchar(1024)             null comment '检测委托书/同(文件id)',
    check_point_map_file_ids          varchar(1024)             null comment '检测点分布示意图',
    check_result_certificate_file_ids varchar(1024)             null comment '检测结果公布凭证',
    related_job_evaluation_id         bigint               null comment '相关工作评价表主键Id',
	evaluate_id                       bigint               null comment '评价id',
	edit_status                       int             default 1 null comment '编辑状态(1:编辑中/存草稿 2：已完成编辑)',
    check_plan_type                   tinyint              default 0 comment '0-正常,3-复采(整改后检测)',
	check_pids                        varchar(5000)        null comment '关联检测Id，多个以逗号隔开 check_plan_type=3（复测）有用',
	project_name                      varchar(512)              null comment '项目名称(来自机构端)',
    project_area_id                   bigint unsigned           null comment '项目区域id(来自机构端)',
    project_address                   varchar(512)              null comment '项目详细地址(来自机构端)',
    give_report_date                  datetime                      null comment '报告出具日期(来自机构端)',
    report_status                     int             default 1 null comment '上报状态(1:未上报 2：已上报 3：被退回)(来自机构端)',
    report_date                       datetime                      null comment '上报日期(来自机构端)',
    contact_name                      varchar(128)              null comment '联系人(来自机构端)',
    contact_phone                     varchar(64)               null comment '联系电话(来自机构端)',
    register_name                     varchar(64) default ''       comment '登记人姓名',
    is_valid                          tinyint(1)      default 1 not null comment '是否有效（0-无效，1-有效）',
    create_by                         bigint unsigned default 0 not null comment '创建人',
    create_date                       datetime                  null comment '创建时间',
    update_by                         bigint unsigned default 0 not null comment '最后修改人ID',
    update_date                       datetime                  null comment '最后修改时间'
)
    comment '检测表';



/*检测项表（有固定数据）*/
DROP TABLE IF EXISTS `check_item`;
CREATE TABLE `check_item` (
id					bigint	    comment 'id',
`name` varchar(64)	comment '名称',
item_type int comment '1:危害因素类型 2：危害因素 3：既不是危害因素类型也不是危害因素表中的危害因素',
factor_type varchar(32) comment 'item_type为1时有效,危害因素类型 occupational_risk_factors表type字段',
factor_id bigint unsigned comment 'item_type为2时有效,危害因素id occupational_risk_factors表id字段',
is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
create_by   bigint unsigned     not null default 0 comment '创建人',
create_date datetime             null   comment '创建时间',
update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
update_date datetime             null  comment '最后修改时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='检测项表';


/*检测选择的检测项目表*/
DROP TABLE IF EXISTS `check_select_item`;
CREATE TABLE `check_select_item` (
id					bigint unsigned	auto_increment    comment 'id',
check_id                 bigint unsigned comment '检测id',
cid                     bigint unsigned comment '企业id',
item_id                 int  comment '检测项id',
is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
create_by   bigint unsigned     not null default 0 comment '创建人',
create_date datetime             null   comment '创建时间',
update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
update_date datetime             null  comment '最后修改时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='检测选择的检测项目表';


/*检测指标表（有固定数据）*/
DROP TABLE IF EXISTS `check_target`;
CREATE TABLE `check_target` (
id					bigint	    comment 'id',
name                varchar(64) comment '指标名称',
unit                varchar(64) comment '指标单位',
item_id             int  comment '所属检测项id',
check_value_type	int comment '值类型1：准确值 2：范围',
tag                 int  comment '标签',
description         varchar(10224) comment '描述',
standard_id			int comment '指标标准id,为0表示公共的',
is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
create_by   bigint unsigned     not null default 0 comment '创建人',
create_date datetime             null   comment '创建时间',
update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
update_date datetime             null  comment '最后修改时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='检测指标表';


/*电离辐射*/
/*电离辐射-射线装置表*/
DROP TABLE IF EXISTS `ray_device`;
CREATE TABLE `ray_device` (
id					bigint unsigned	    comment 'id',
check_id                 bigint unsigned comment '检测id',
name    varchar(128) comment '装置名称',
model_no varchar(128) comment '型号',
capacity    varchar(128) comment '额定容量',
check_condition    varchar(512) comment '检测条件',
site_name    varchar(128) comment '场所名称',
is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
create_by   bigint unsigned     not null default 0 comment '创建人',
create_date datetime             null   comment '创建时间',
update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
update_date datetime             null  comment '最后修改时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='电离辐射-射线装置表';
ALTER TABLE `ray_device` ADD COLUMN `workshop_name` VARCHAR(128) NULL COMMENT '检测点所在车间(v315车间名称)' AFTER `update_date`,
                         ADD COLUMN `work_name` VARCHAR(128) NULL COMMENT '岗位/工种(v315岗位名称)' AFTER `workshop_name`,
                         ADD COLUMN `harm_staff_count` INT(11) NULL COMMENT '接触人数（v315定员）' AFTER `work_name`;

/*电离辐射-含源装置表*/
DROP TABLE IF EXISTS `ray_source_device`;
CREATE TABLE `ray_source_device` (
id					bigint unsigned	    comment 'id',
check_id                 bigint unsigned comment '检测id',
name    varchar(128) comment '装置名称',
ray_source_no varchar(128) comment '放射源编号',
sign_no    varchar(128) comment '标号',
nucleus_el    varchar(512) comment '核素,格式:元素名称-原子量',
now_active_degree    varchar(128) comment '当前活度（Bq）',
factory_active_degree    varchar(128) comment '出厂活度（Bq）',
install_location    varchar(128) comment '安装位置',
is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
create_by   bigint unsigned     not null default 0 comment '创建人',
create_date datetime             null   comment '创建时间',
update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
update_date datetime             null  comment '最后修改时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='电离辐射-含源装置表';
ALTER TABLE `ray_source_device` ADD COLUMN `workshop_name` VARCHAR(128) NULL COMMENT '检测点所在车间(v315车间名称)' AFTER `update_date`,
                                ADD COLUMN `work_name` VARCHAR(128) NULL COMMENT '岗位/工种(v315岗位名称)' AFTER `workshop_name`,
                                ADD COLUMN `harm_staff_count` INT(11) NULL COMMENT '接触人数（v315定员）' AFTER `work_name`;




/*检测结果表*/
DROP TABLE IF EXISTS `check_result`;
CREATE TABLE `check_result` (
  `id`  bigint unsigned COMMENT '主键id',
  `check_id` bigint unsigned NOT NULL COMMENT '检测id',
  `cid` bigint unsigned NOT NULL COMMENT '企业id',
  `result_no` bigint unsigned NOT NULL COMMENT '结果集编号,相同编号则为同一批录入结果',
  `target_id` int  NOT NULL COMMENT '指标id',
  `check_value` varchar(64)  default NULL COMMENT '指标的值（准确值）',
  `check_value_range_type` int  default NULL COMMENT '结果是范围时，范围类型：1:-，2:< ，3:<=',
  `check_value_min` varchar(16)  default NULL COMMENT '指标的值（范围下限）',
  `check_value_max` varchar(16)  default NULL COMMENT '指标的值（范围上限）',
  `unit` varchar(16)  default NULL COMMENT '单位（单位如果是用户填的或需要动态改变的，存该字段）',
   is_valid    bool                not null default true  comment '是否有效（0-无效，1-有效）',
   create_by   bigint unsigned     not null default 0 comment '创建人',
   create_date datetime             null   comment '创建时间',
   update_by   bigint unsigned     not null default 0 comment '最后修改人ID',
   update_date datetime             null  comment '最后修改时间',
   index (`cid`),
   index (`result_no`),
   index (`check_id`),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='检测结果表';



