/*实施版增加字段*/
alter table check_plan add column  manager_name varchar(128) comment '负责人姓名';

/*上报状态增加 已忽略*/
alter table check_plan modify column report_status int default 1 comment '上报状态(1:未上报 2：已上报 3：被退回 4:已忽略)';

/*增加数据关联工作状态字段*/
alter  table check_plan  ADD  relevance_status int not null  default 0 comment '数据关联工作状态(实施版)0:无关联 1：进行中 2：已完成';
alter  table check_plan  ADD  relevance_date datetime default null   comment '数据关联工作完成时间';

/*检测新增字段*/
alter table check_plan add check_evaluation_report_file_ids varchar(256) comment '检测评价报告附件ids(与检测报告不同)';
alter table check_plan add check_evaluation_report_location varchar(256) comment '检测评价报告存放位置';

/*更新指标所属标准id*/
update check_target set standard_id = 2 where id=8;
update check_target set standard_id = 1 where id=9;

update check_target set standard_id = 2 where id=15;
update check_target set standard_id = 1 where id=16;

update check_target set standard_id = 2 where id=20;
update check_target set standard_id = 1 where id=21;


/*检测添加字段*/
ALTER TABLE check_plan add org_ids varchar(512) COMMENT '工作记录所属部门id，多个用逗号分隔(实施版)';


/**************************2020-20-23***************************************************/
/*采样点忽略表*/
drop table if exists `check_point_ignore`;
create table check_point_ignore
(
    id          bigint          default 0 not null comment 'id' primary key,
    cid     bigint not null comment '企业id',
    result_no    bigint not null comment '忽略的采样点的结果集编号',
    is_valid    tinyint(1)      default 1 not null comment '是否有效（0-无效，1-有效）',
    create_by   bigint unsigned default 0 not null comment '创建人',
    create_date datetime                  null comment '创建时间',
    update_by   bigint unsigned default 0 not null comment '最后修改人ID',
    update_date datetime                  null comment '最后修改时间'
)
    comment '采样点忽略表（实施）';

/*已经添加了整改信息的采样点*/
drop table if exists `have_add_reform_check_point`;
create table have_add_reform_check_point
(
    id          bigint          default 0 not null comment 'id' primary key,
    cid     bigint not null comment '企业id',
    batch_no     bigint not null comment  '批次号',
    result_no    bigint not null comment '采样点的结果集编号',
    is_valid    tinyint(1)      default 1 not null comment '是否有效（0-无效，1-有效）',
    create_by   bigint unsigned default 0 not null comment '创建人',
    create_date datetime                  null comment '创建时间',
    update_by   bigint unsigned default 0 not null comment '最后修改人ID',
    update_date datetime                  null comment '最后修改时间'
)
    comment '已经添加了整改信息的采样点（实施）';
/*整改后检测*/
alter table check_plan add last_check_ids  varchar(512) comment '上一次检测id(整改后检测该字段有效，实施版)';
alter table check_plan add reform_ids varchar(512)  default null comment '整改后检测涉及的隐患id（多个逗号隔开），实施版)';