package cn.smarthse.services.hfi.api.service.riskev;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.grade.CompanyOccTypeVo;
import cn.smarthse.services.hfi.api.model.grade.GradeSearchBaseModel;
import cn.smarthse.services.hfi.api.model.riskev.ComEvModel;
import cn.smarthse.services.hfi.api.model.riskev.ComEvModelParam;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.model.riskev.QueryPageListReportsParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.FactorTouchNumVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskEvaluateSelfCheckVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskExposeEvaluateVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author 邓力宾
 * @date 2022/3/16 10:47
 * @desc
 */
public interface IRiskExposeEvaluateService extends IBaseService<RiskExposeEvaluate> {

    /**
     *根据机构对企业上报的最新检测数据自动生成一条 风险暴露评估
     * @param orgId
     * @param cid
     * @return
     */
    RiskExposeEvaluate autoAddByOrgAndCom(Long orgId, Long cid);

    /**
     * 自动添加企业的评估数据
     * @param orgId
     */
    void  autoAddByOrg(Long orgId);
     /**
      *@ Description: <自动添加暴露风险数据>
      *@ Author XiaoYi
      *@ Date  2022/5/16  10:55
      *@ param
      *@ return
     **/
    void   autoAddRiskExposeEvaluateFromCheck();

    void   autoAddRiskExposeEvaluateFromWandaCheck(List<CheckPlan> checkPlanList,Map<Long, Long> checkIdKeyRiskIdValue);

    void   autoAddRiskExposeEvaluateFromWandaZywsReport(String sourceId);




    /**
     * 获取机构对企业的最新一条风险评估 没有返回null
     */
    RiskExposeEvaluate getLatestByOrgAndCom(Long orgId, Long cid);

    RiskExposeEvaluate getByCheckId(Long checkId);

    void deleteByCheckId(Long checkId);

    /**
     * 获取机构对企业的风险评估(来自检测) 没有返回null
     * @param orgId
     * @param cid
     * @return
     */
    RiskExposeEvaluate getFromCheckPlanByOrgAndCom(Long orgId, Long cid);

    /**
     * 风险暴露评估分页查询
     * @param param
     * @return
     */
    PageInfo<RiskExposeEvaluateVo> queryPage(EvQueryParam param);

    /**
     *  风险暴露评估-接触人数及风险判定
     * @param evId
     * @return
     */
    RiskDecisionVo queryTouchNumAndLevel(Long evId);

    /**
     * 查询评估报告表-用人单位职业病危害暴露情况调查和风险评估报告列表
     * @param param
     * @return
     */
    PageInfo<RiskEvaluateSelfCheckVo> queryPageListReports(QueryPageListReportsParam param);

    /**
     * 指定年份条件获取最新一条评估
     * @param cid 不能为空
     * @param year 为空时取最近三年包括当年（比如2023年时，有2020，2021，2022，，2023）
     * @param year 不为null时指定某年份
     * @param reportStatus 提交状态(1:待提交 2：待审核 3：被退回待提交 4：审核完成 可以为空
     * @return
     */
    RiskExposeEvaluate getLatestEv(Long cid, Integer year, Integer  reportStatus);
    /**
     * 获取最新一条在已审核数据之后的已上报的暴露风险(如果没有已审核的数据就获取最新的已上报的)
     * （取最近三年包括当年（比如2023年时，有2020，2021，2022，，2023））
     * @param cid 不能为空
     * @return
     */
    RiskExposeEvaluate getLatestNeedReportEv(Long cid);


    /**
     * 企业评估 按企业分组
     * @param param
     * @return
     */
    List<ComEvModel> comEvModel(ComEvModelParam param);

    /**
     * 根据id查询
     * @param ids
     * @return 返回id->对象
     */
    Map<Long, RiskExposeEvaluate> queryByIds(List<Long> ids);

    /**
     * 计算风险等级 上报时或审核通过是调用
     * @param evId
     */
    void updateRiskLevel(Long evId);





    /**
     * 危害因素接触人数统计
     * @param areaId
     * @param areaLevel
     * @return
     */

    FactorTouchNumVo touchNumStat(GradeSearchBaseModel gradeSearchBaseModel);

    FactorTouchNumVo deleteKey(GradeSearchBaseModel gradeSearchBaseModel);

    /**
     * 获取对应暴露风险表的 CID 和 暴露风险级别
     * @param evIds
     * @return  key : cid
     *          value : 风险等级，1：低风险，2：中风险，3：高风险
     */
    Map<Long, Integer> queryRiskLevelList(List<Long> evIds);
    /**
     * 获取对应暴露风险表的 CID 和 暴露风险级别
     * @param evIds
     * @return  key : id
     *          value : 风险等级，1：低风险，2：中风险，3：高风险
     */
    Map<Long, Integer> queryRiskIdLevelMapList(List<Long> evIds);

    List<RiskExposeEvaluate> getbyOrgId(Long orgId);

    /**
     * 更新风险暴露状态（只会传原始表进来）
     * （如果是退回状态：本地上传的退回还要生成一份副本，万达仓的退回万达仓。然后判断有没有合并表也更新状态）
     * （如果是一键审核：都是正常流程，如果是合并表，就查询那些表合并的，把那部分也审核通过）
     *
     * @param evId   evId
     * @param state  状态
     * @param userId 用户id
     * @param backType 退回的类型，1是放射机构，2是职业健康体检机构，多选则用逗号拼接。不是1和2的话，就是合并表的id
     * @return {@code Long }
     * @author zhangxu
     * @date 2023-03-20
     */
    public int updateRiskExposeCheckState(Long evId, Integer state, Long userId,String reason,String backType);
    /**
     * @Comments:  <更加update_date 获取最新的 暴露风险数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/6/20-14:58
     * @param beginDate
     * @param endDate
     * @param cid
     * @return java.util.List<cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate>
    */
    List<RiskExposeEvaluate> listRiskEvaluateLasted(Date beginDate, Date endDate, List<Long> cids);


    List<String> updateRiskLevel();


    List<Map> listRiskEvaluateCompanyInfo(Long areaId, Byte areaLevel);

    List<RiskExposeEvaluate> updateRiskLevelAndLog(Integer page,Integer size);

    List<RiskExposeEvaluate> updateRiskLevelNew( List<RiskExposeEvaluate> list);

    /**
     * 涉害企业数量（辖区内所有存在危害因素的正常经营+暂停营业的企业    取申报企业、有暴露风险评估企业的合集）
     *
     * @param areaId
     * @param areaLevel
     * @param isBelongType
     * @return java.lang.Integer
     * @author ShenZQ
     * @since 2022/11/10 9:40
     */
    Integer getContactHarmComNumByArea(Long areaId, Byte areaLevel,Boolean isBelongType);

    /**
     * 涉害企业id（辖区内所有存在危害因素的正常经营+暂停营业的企业    取申报企业、有暴露风险评估企业的合集）
     *
     * @param areaId
     * @param areaLevel
     * @param isBelongType
     * @return java.util.List<java.lang.Long>
     * @author ShenZQ
     * @since 2022/11/10 9:39
     */
    Set<Long> getContactHarmComCidByArea(Long areaId, Byte areaLevel,Boolean isBelongType);

    /**
     * 涉害企业-按危害因素类型分组
     *
     * @param areaId                区域id
     * @param areaLevel             区域层面
     * @param isBelongType          是属于类型
     * @param isFcImportanceCompany
     * @return {@link Map }<{@link String }, {@link Integer }>
     * @author zhangxu
     * @date 2023-04-23
     */
    Map<String, Integer> getContactHarmTypeComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType, Integer isFcImportanceCompany);

    /**
     * 接害人员总数-按危害因素类型分组
     *
     * @param searchBaseModel 搜索基本模型
     * @return {@link Map }<{@link String }, {@link Integer }>
     * @author zhangxu
     * @date 2023-04-23
     */
    Map<String, Integer> getContactHarmTypeStaffNumByArea(GradeSearchBaseModel searchBaseModel);

     /**
      *@ Description: <有暴露风险数据的企业>
      *@ Author XiaoYi
      *@ Date  2022/7/16  11:48
      *@ param
      *@ return
     **/
    Integer getRiskComNumByArea(Long areaId, Byte areaLevel,Boolean isBelongType);


    void invalidRiskEv(Long cid,Long evId);

 /**
  *@ Description: <判断是否治理企业>
  *@ Author XiaoYi
  *@ Date  2022/7/16  21:07
  *@ param
  *@ return
 **/
 Set<Long> getIsGovern(List<Long> cids);

 /**
  *@ Description: <获取企业最新一次暴露风险数据的岗位和部门，及接触危害因素>
  *@ Author XiaoYi
  *@ Date  2022/8/3  13:45
  *@ param
  *@ return
 **/
    Map<String, RiskExposeEvaluateData> getComConcatWorkAndDept(Long cid);

    /**
     * 获取所有已上报未同步至检测的暴露风险id
     * @return
     */
    List<Long> getAllRiskByNoChecked();

    /**
     * 获取暴露风险关联third——org，带名称
     * @param newListRiskid
     * @return
     */
    List<RiskExposeEvaluate> getInfoList(List newListRiskid);

     /**
      * 从暴露风险获取--已上报且职业病危害类别不为空的
      *@ Description: <获取企业最新数据的职业病危害类别>
      *@ Author XiaoYi
      *@ Date  2022/11/8  14:19
      *@ param
      *@ return
     **/
     public Map<Long, CompanyOccTypeVo> getCompanyOccTypeMap(Long cid) ;

    /**
     * 从检测获取--所有状态的且职业病危害类别不为空的
     *
     * @param cid    cid
     * @param begin  开始
     * @param end    结束
     * @param status 状态  暂时没用这个字段，方便线上有需求的时候更新
     * @return {@code Map<Long, CompanyOccTypeVo> }
     * @ Description: <获取企业最新数据的职业病危害类别>
     * @ Author XiaoYi
     * @ Date  2022/11/8  14:19
     * @ param
     * @ return
     * @author zhangxu
     * @date 2023-05-19
     */
    public Map<Long, CompanyOccTypeVo> getCompanyOccTypeMap(List<Long> cids,Date begin,Date end,Byte status);


    /**
     * 获取最近一次待审核的记录
     * @param cid
     * @return
     */
    RiskExposeEvaluate getLastInfoToBeReviewedByCid(Long cid);

    /**
     * 获取企业最新接触危害人数(通过最新暴露风险)
     * @param cidList（不能为空，不是查询所有，数据太多了）建议一次1000条，本地14万条3分钟就完了
     * @return  只返回了有数据有接害人数的企业    字段cid，workNum（接害人数），lastDate（最新时间）
     */
    List<RiskExposeEvaluate> getTouchHarmPeopleNumber(List<Long> cidList);

    FactorTouchNumVo touchNumStat2(GradeSearchBaseModel gradeSearchBaseModel);

    public FactorTouchNumVo touchNumStatByReport(GradeSearchBaseModel gradeSearchBaseModel);

    /**
     * 退回状态时，为实现监管看到的数据不变，生成的一份假数据，提交的时候更新副本的id为原来的id
     *
     * @param exposeEvaluate 暴露评估
     * @return {@code Long }
     * @author zhangxu
     * @date 2023-03-20
     */
    Long backSubmitChangeOldId(RiskExposeEvaluate exposeEvaluate);

    /**
     * 通过checkId查询risk，然后删除risk相关的子表
     *
     * @param checkPlanIdList 检查计划id列表
     * @return {@code List<RiskExposeEvaluate> }
     * @author zhangxu
     * @date 2023-03-22
     */
    List<RiskExposeEvaluate> getRiskByCheckIdAndDeleteOther(List<Long> checkPlanIdList);


    /**
     * 只有放射企业才需要： 合并放射和万达转换过来的暴露为一张新表（取最新检测时间，并且创建时间往后延，确保那边取到最新一条逻辑不变）
     *  合并的表包括待审核和已完成审核，下面还有个类似方法只有待审核的
     * @param cid cid
     * @param riskId
     * @param years 取最近三年包括当年（比如2023年时，有2020，2021，2022，，2023）
     * @return {@link RiskExposeEvaluate }
     * @author zhangxu
     * @date 2023-03-28
     */
    RiskExposeEvaluate mergerAdiationAndWandaRisk(Long cid, Long riskId,List<Integer> years);

    /**
     * 只有放射企业才需要：万达更新risk和本地退回提交时调用
     * 通过子表riskID更新合并表为退回状态的
     *
     * @param evaluate 风险暴露评估  需要状态为待审核2、cid和id、更新人
     * @return {@link Integer }
     * @author zhangxu
     * @date 2023-04-02
     */
    Integer updateMergerTableByChildRisk(RiskExposeEvaluate evaluate);


    /**
     * 查询放射企业是否包含放射因素和非放射因素
     *
     * @param riskId 风险id
     * @param cid    cid
     * @return {@link Integer }
     * @author zhangxu
     * @date 2023-04-10
     */
    Integer getIsFangSheRiskInfoComplete(Long riskId, Long cid);


    /**
     * 只有放射企业才需要：获取放射企业产生合并表的所有关联id
     * @param cid cid
     * @return {@link Long }
     * @author zhangxu
     * @date 2023-04-02
     */
   List<Long> getRedundantSourceTablesIdsIsNotNullByCid(Long cid);

    /**
     * 获取最新暴露风险数据
     *
     * @return {@link List }<{@link RiskExposeEvaluate }>
     * @author zhangxu
     * @date 2023-05-14
     */
    List<RiskExposeEvaluate> getLastEv(EvQueryParam param);
    List<RiskExposeEvaluate> getListByParam(EvQueryParam param,Map<String,Object> paramMap);

    /**
     * 获取企业最新接触危害人数(通过最新暴露风险)
     *
     * @author zhangxu
     * @date 2023-05-30
     */
    void insertTouchHarmPeopleNumber();

    List<String> getWorkShopNameAndNumDiffer(Long evId);

    /**
     * 查询近三年的检测数据中，“分类为严重”的危害因素存在“不符合”的检测结果的数量
     * @param cid
     * @return
     */
    Integer countHazardFactorHarmfulInconformityNum(Long cid,Byte factorNature);
}
