package cn.smarthse.services.hfi.api.service.riskev;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.model.result.ListParamModel;
import cn.smarthse.services.hfi.api.model.result.RadiateRiskListModel;
import cn.smarthse.services.hfi.api.model.riskev.EvDataStatModel;
import cn.smarthse.services.hfi.api.model.riskev.EvTouchNumStat;
import cn.smarthse.services.hfi.api.model.riskev.QueryPageRiskEvDataParam;
import cn.smarthse.services.hfi.api.pojo.vo.CheckFileVo;
import cn.smarthse.util.common.excel.model.ExcelModel;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @author 邓力宾
 * @date 2022/3/16 10:46
 * @desc
 */
public interface IRiskExposeEvaluateDataService extends IBaseService<RiskExposeEvaluateData> {


    void importDataFromCheck(Long orgId);

    /**
     * 添加数据
     */
    void addByCheckPlan(RiskExposeEvaluate obj);


    void addDataFromCheckPlan(RiskExposeEvaluate obj);


    /**
     * 检测结果转换为 风险暴露评估的数据
     * @param obj 风险暴露评估主表 对象
     * @param checkFileVos 检测结果数据
     * @return
     */
    List<RiskExposeEvaluateData> checkFileVoToEvListData(RiskExposeEvaluate obj, List<CheckFileVo> checkFileVos);

    /**
     * 用人单位职业病危害暴露情况调查和风险评估表
     * @param evId
     * @return
     */
    List<RiskExposeEvaluateData> queryByEvId(Long evId);


    /**
     * 导入数据 （历史数据做更新）
     * @param excelModel
     * @param evId
     */
    void doImportEvData(ExcelModel excelModel, Long evId, Long userId) throws ParseException;

    /**
     * 统计危害因素接触人数
     * @param evId
     * @return
     */
    List<EvDataStatModel> queryEvDataStat(Long evId);

    /**
     *  分页查数据列表
     * @param param
     * @return
     */
    PageInfo<RiskExposeEvaluateData> queryPageDataList(QueryPageRiskEvDataParam param);
     /**
      *@ Description: <结果排序超标的排前面>
      *@ Author XiaoYi
      *@ Date  2022/7/15  9:03
      *@ param
      *@ return
     **/
    PageInfo<RiskExposeEvaluateData> queryPageDataListOrderByLevel(QueryPageRiskEvDataParam param);

    /**
     * 职业病危害因素浓度或强度 自查 第6项结果 接口
     * @param evId
     * @return
     * 获取暴露风险关联自查第六项的检查结果（1:符合 2:基本符合 3:不符合）	
获取最新暴露风险里的危害因素:
1.先判断只要有一条危害因素(接触水平:超标+职业病危害因素性质:严重)就是不符合
2.然后再判断只要有一条危害因素(接触水平:超标+职业病危害因素性质:一般)就是基本符合
     */
    Integer selfCheckSixResult(Long evId);

    /**
     * 导入接触水平 与 自动检测接触水平 比较
     * @param evId
     * @return
     */
    boolean touchLevelCompare(Long evId);

    /**
     * 逻辑删除-根据id批量删除数据
     * @param dataIds
     */
    void logicDelByIds(List<Long> dataIds);

    /**
     * 逻辑删除-根据暴露风险主表删除批量删除数据
     * @param dataIds
     */
    void logicDelByEvId(Long evId);


    /**
     * 批量保存
     * @param list
     */
    void saveOrUpdateList(List<RiskExposeEvaluateData> list,Boolean resetPePcTwa);


    /**
     * 根据值和限值判断是否超标
     * @param data
     * @return 1：超标 2：不超标
     */
    Integer queryTouchLevel(RiskExposeEvaluateData data);

    /**
     * 危害因素是否异常
     * @param data
     * @return
     */
    Boolean factorAbnormal(RiskExposeEvaluateData data);

    /**
     * 统计
     * @param evIds 暴露风险评估id
     * @return 暴露风险评估id->统计对象
     */
    Map<Long, EvTouchNumStat> evTouchStat(List<Long> evIds);
    /**
     * @param  evId
     */
    boolean isOverQuotaByEvId(Long evId);

    /**
     * 根据部门车间分组，获取危害因素
     *
     * @param evId evId
     * @return {@link List }<{@link RiskExposeEvaluateData }>
     * @author zhangxu
     * @date 2023-05-14
     */
    List<RiskExposeEvaluateData> getRiskDataByShopAndNameGroup(Long evId);

    /**
     * 根据部门,检测点分组，获取危害因素
     *
     * @param evId evId
     * @return {@link List }<{@link RiskExposeEvaluateData }>
     * @author zhangxu
     * @date 2023-05-14
     */
    List<RiskExposeEvaluateData> getRiskDataByShopAndPointGroup(Long evId);

    List<RadiateRiskListModel> getRadiateRiskList(ListParamModel param);
}
