package cn.smarthse.services.hfi.api.service;

import cn.smarthse.services.hfi.api.model.HarmStatQueryModel;
import cn.smarthse.services.hfi.api.pojo.vo.ChemicalHarmComStatVo;
import cn.smarthse.services.hfi.api.pojo.vo.DustHarmComStatVo;
import cn.smarthse.services.hfi.api.pojo.vo.HarmComTotalCountVo;
import cn.smarthse.services.hfi.api.pojo.vo.NoiseHarmComStatVo;
import com.github.pagehelper.PageInfo;

/**
 * @author 邓力宾
 * @date 2020/11/10 11:34
 * @desc 监管端， 危害因素 企业数统计接口 本年度
 */
public interface IHarmComCountService {

    /**
     * 粉尘  企业数统计接口
     * @param harmStatQueryModel
     * @return
     */
    PageInfo<DustHarmComStatVo> dustCount(HarmStatQueryModel harmStatQueryModel);

    /**
     * 化学  企业数统计接口
     * @param harmStatQueryModel
     * @return
     */
    PageInfo<ChemicalHarmComStatVo> chemicalCount(HarmStatQueryModel harmStatQueryModel);

    /**
     * 噪声  企业数统计接口
     * @param harmStatQueryModel
     * @return
     */
    PageInfo<NoiseHarmComStatVo> noiseCount(HarmStatQueryModel harmStatQueryModel);

    /**
     * 粉尘 合计统计
     * @param harmStatQueryModel
     * @return
     */
    HarmComTotalCountVo allDustCount(HarmStatQueryModel harmStatQueryModel);

    /**
     * 化学 合计统计
     * @param harmStatQueryModel
     * @return
     */
    HarmComTotalCountVo allChemicalCount(HarmStatQueryModel harmStatQueryModel);

    /**
     * 噪声 合计统计
     * @param harmStatQueryModel
     * @return
     */
    HarmComTotalCountVo allNoiseCount(HarmStatQueryModel harmStatQueryModel);


}
