package cn.smarthse.services.hfi.api.service;

import cn.smarthse.modules.datacentre.model.system.riskFactors.FactorLimitValue;

import java.util.List;
import java.util.Map;

/**
 * @author 邓力宾
 * @date 2020/10/21 11:11
 * @desc 危害因素职业接触限值接口
 */
public interface IFactorLimitValueService {


    /**
     * 根据危害因素id和指标 获取该指标的限值
     * @param factorId 危害因素id （化学，粉尘，生物类）
     * @param targetId 指标
     * @return
     */
    String getByFactorAndTargetId(Long factorId, Integer targetId);


    /**
     * 根据危害因素查询限值
     * @param factorId 危害因素id 噪声 化学 粉尘
     * @param key 指标 化学: twa(ctwa) stel(ste和stel) mac(cme和cmac) max_excursion_limit (超限倍数)
     *            粉尘: twa_total(总尘twa) twa_respirabel(呼尘twa)
     * @return
     */
    String get(Long factorId, String key);

    /**
     * 获取危害因素具有的限值 key
     * @param factorId
     * @return 化学 化学: twa(ctwa) stel(ste和stel) mac(cme和cmac) max_excursion_limit (超限倍数)
     * 粉尘 twa_total(总尘twa) twa_respirabel(呼尘twa)
     */
    List<String> getFactorLimitKeys(Long factorId);

    /**
     * 验证给定的危害因素是否有总尘 或 呼尘
     * @param factorId
     * @return  包含1 总尘， 包含2 呼尘
     */
    public String containsZongHu(Long factorId);
    /**
     * 获取危害因素具有的限值 key
     * @param factorIds
     * @return 化学 化学: twa(ctwa) stel(ste和stel) mac(cme和cmac) max_excursion_limit (超限倍数)
     * 粉尘 twa_total(总尘twa) twa_respirabel(呼尘twa)
     */
    Map<Long, List<String>> getFactorLimitKeys(List<Long> factorIds);

    /**
     * 刷新缓存
     */
    void refreshCache();

    /**
     * 获取单位
     * @param factorId
     * @param targetId
     * @return
     */
    String getTargetNameByFactorAndTargetId(Long factorId, Integer targetId);

    /**
     * 查询危害因素限值
     * @param factorIds
     * @return 危害因素id-> 属性名 ->限值
     * 属性名:化学: twa(ctwa) stel(ste和stel) mac(cme和cmac) max_excursion_limit (超限倍数)
     *       粉尘: twa_total(总尘twa) twa_respirabel(呼尘twa)
     */
    Map<String, Map<String, String>> queryLimitValues(List<String> factorIds);

    /**
     * 查询粉尘危害因素限制(总尘、呼尘)
     * 值为空时代表不存在
     * @return
     */
    List<FactorLimitValue> queryFCLimitValues();
}
