package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.ComOverRate;
import cn.smarthse.services.hfi.api.pojo.vo.ComOverRateVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * <p>
 * 企业超标率统计结果表（监管需求02-046） 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-24
 */
public interface IComOverRateService extends IBaseService<ComOverRate> {

    /**
     * 开始统计，立即执行， 比较耗时（可以定时执行）
     */
    void startStatistic();

    /**
     * 根据阈值 查询 满足一个即可
     * @param  areaId 区域id
     * @param  areaLevel 区域级别
     * @param chemicalRate 化学超标率
     * @param dustRate 粉尘超标率
     * @param noiseValue 噪声值
     * @param totalRate 总超标率
     * @param ownLevel 是否只查本级
     * @return
     */
    List<ComOverRateVo> queryByThresholdAndArea(Long areaId, Byte areaLevel,
                                                String chemicalRate, String dustRate,
                                         String noiseValue, String totalRate, Byte ownLevel);

    /**
     * 根据阈值 分页查询 满足一个即可
     * @param areaId
     * @param areaLevel
     * @param chemicalRate
     * @param dustRate
     * @param noiseValue
     * @param totalRate
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<ComOverRateVo> queryPageByThresholdAndArea(Long areaId, Byte areaLevel,
                                                        String chemicalRate, String dustRate,
                                                        String noiseValue, String totalRate,
                                                        int pageNum, int pageSize, Byte ownLevel);
}
