package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckTarget;

import java.util.List;

/**
 * <p>
 * 检测指标表 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
public interface ICheckTargetService extends IBaseService<CheckTarget> {

    /**
     * 根据检测项查询该检测项下的检测指标
     * @param itemId 检测项id
     * @return 检测项 集合 按id升序
     */
    List<CheckTarget> getByItem(Long itemId);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    CheckTarget getByIdFromCache(Long id);

    /**
     * 根据检测项和标准id查询该检测项下的检测指标
     * @param itemId 检测项id
     * @param standardId 标准id
     * @return 检测项 集合 按id升序
     */
    List<CheckTarget> getByItemAndStandard(Long itemId, Long standardId);

    /**
     * 刷新缓存的指标
     */
    void refreshCache();
}
