package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;

import java.util.List;

/**
 * <p>
 * 检测选择的检测项目表 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
public interface ICheckSelectItemService extends IBaseService<CheckSelectItem> {

    /**
     * 查询检测选择的检测项
     * @param checkId
     * @return
     */
    List<CheckSelectItem> getByCheck(Long checkId);

    /**
     * 查询检测选择的检测项
     * 过滤掉没有检测结果的item
     * @param checkId
     * @return
     */
    List<CheckSelectItem> getByCheckFilterNoData(Long checkId);

    /**
     * 查询检测结果中有不符合的选择的检测项
     * @param checkId
     * @return
     */
    List<CheckSelectItem> getHaveOverPointItemByCheck(Long checkId);

    /**
     * 更新检测选择的检测项目
     * @param selectItems
     */
    void updateCheckItems(List<CheckSelectItem> selectItems);

    /**
     * 删除检测项
     * @param checkId
     * @param itemId
     */
    void deleteCheckItem(Long checkId,Long itemId);


    /**
     * 根据企业查询选择的检测项目
     * @param cid
     * @return
     */
    List<CheckSelectItem> getByCid(Long cid);





}
