package cn.smarthse.services.hfi.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.model.CheckPointSelectVoParamModel;
import cn.smarthse.services.hfi.api.model.result.CheckResultFormModel;
import cn.smarthse.services.hfi.api.model.result.RayDeviceFormModel;
import cn.smarthse.services.hfi.api.pojo.bo.CheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.ChemicalCheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.DustCheckResultBo;
import cn.smarthse.services.hfi.api.pojo.vo.*;
import com.github.pagehelper.PageInfo;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 检测结果表 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
public interface ICheckResultService extends IBaseService<CheckResult> {

    /**
     * 添加或更新检测结果
     * @param checkResults
     */
    void addOrUpdate(List<CheckResult> checkResults);

    /**
     *
     * 同步所有指定暴露至检测，分批
     */
    void getFetchResults(List<Long> checkId,List<CheckResult> checkResults);
    /**
     * 查询结果值
     * @param checkId 检测id
     * @param itemId 检测项id
     * @return
     */
    List<CheckResult> queryResult(Long checkId, Long itemId);


    void deleteResultByCheckItem(Long checkId, Long itemId);

    /**
     * 计算化学因素的检测超标率 保留4位小数
     * @param checkIds 检测id （多个）
     * @return
     */
    String calculateChemicalOverRate(List<Long> checkIds);
    /**
     * 计算粉尘的检测超标率 保留4位小数
     * @param checkIds 检测id （多个）
     * @return
     */
    String calculateDustOverRate(List<Long> checkIds);

    /**
     * 获取 噪声的检测结果 多个用逗号隔开
     * @param checkIds 检测id （多个）
     * @return
     */
    String getNoiseValues(List<Long> checkIds);
    /**
     * 计算总的检测超标率 保留4位小数
     * @param checkIds 检测id （多个）
     * @return
     */
    String calculateTotalOverRate(List<Long> checkIds);

    /**
     * 根据企业和指标查询检测结果
     * @param cid 企业
     * @param targets 指标id 集合
     * @return
     */
    List<CheckResult> getByCidAndTargets(Long cid, List<Integer> targets);

    /**
     * 根据检测和指标查询检测结果
     * @param checkId 检测id
     * @param targets 指标id 集合
     * @return
     */
    List<CheckResult> getByCheckIdAndTargets(Long checkId, List<Integer> targets);

    /**
     * 获取电离辐射射线装置和含源装置的检测结果
     * @param id 射线装置或含源装置的id
     * @param type 76射线装置id,80 含源装置的id
     * @return
     */
    List<CheckResult> queryIonizingRadiationResult(Long id, int type);
    /**
     * 根据判定结果 返回 检测点（需判定的个数） 合格点（符合） 超标点（不符合）
     * @param results 判定结果（多个 按结果集号排序，因为一个结果集可以有多个判定结果 只要有一个不符合这个结果集算不符合）
     * @return 数组 0：检测个数 1：合格点个数 2：超标点个数
     */
    Integer[] getPoint(List<CheckResult> results);

    /**
     * 根据检测 返回 检测点（需判定的个数） 合格点（符合） 超标点（不符合）
     * @param checkId 检测id
     * @return 数组 0：检测个数 1：合格点个数 2：超标点个数
     */
    Integer[] getPointByCheck(Long checkId);

    /**
     * 获取检测的所有检测结果（包括逻辑删除的）
     * @param checkId
     * @return
     */
    List<CheckResult> getByCheckId(Long checkId);

    int queryResult(Long hcId);

    void deleteByRowNum(Long dataId);

    void deleteByRowNums(Long[] dataIds);

    Map<String, CheckResult> getResultMapBydataId(Long dataId,Boolean clone);

    void updateCheckResult(CheckResultFormModel form);

    void updateRayResult(RayDeviceFormModel model);

    /**
     * 获取判定结果为不符合 itemId
     * @param checkId
     * @return
     */
    List<Integer> getHaveOverPointItemIds(Long checkId);

    /**
     * 获取同一结果集(一行) 的判定结果 （有多个判定结果的，只要有一个不符合就算不符合）
     * @param row
     * @return 1：不判定 2：符合 3：不符合 无数据返回空字符串
     */
    String getJudgeResult(List<CheckResult> row);


    /**
     * 统计所有检测超标点
     */
     void statisticAll(List<Long> cidList);
     void statisticBatch(List<CheckResult> checkResults);

    /**
     * 根据检测id统计该检测的检测点 合格点 超标点
     * @param cid cid
     * @param checkId 检测id
     */
    CheckOverPoint statistic(Long cid, Long checkId);

    /**
     * 根据检测时间范围查询化学危害因素的检测结果 按危害因素，结果集编号，检测指标 排序
     * @param start
     * @param end
     * @return
     */
    List<CheckResultBo> queryChemicalFactorResult(LocalDateTime start, LocalDateTime end);
    /**
     * 根据检测时间范围查询粉尘危害因素的检测结果 按危害因素，结果集编号，检测指标 排序
     * @param start
     * @param end
     * @return
     */
    List<CheckResultBo> queryDustFactorResult(LocalDateTime start, LocalDateTime end);

    /**
     * 根据检测时间范围查询化学危害因素的检测结果 按危害因素分组， 检测指标有多个值的取最大值
     * @param start
     * @param end
     * @return
     */
    List<ChemicalCheckResultBo> queryChemicalFactorResultGroupByFactor(LocalDateTime start, LocalDateTime end);

    /**
     * 根据检测时间范围查询化学危害因素的检测结果 按危害因素分组， 检测指标有多个值的取最大值
     * @param start
     * @param end
     * @return
     */
    List<DustCheckResultBo> queryDustFactorResultGroupByFactor(LocalDateTime start, LocalDateTime end);

    /**
     * 根据检测 获取检测指标最新一条检测结果 实施版
     * @param checkId 检测id
     * @param targetId 指标id
     * @return
     */
    CheckResult getLatest(Long checkId, Long targetId);

    /**
     * 获取危害因素最新一条检测结果 实施版
     * @param cid 企业id
     * @param factorId 危害因素id
     * @param checkIds 只要这些检测的
     * @return
     */
    List<HarmFactorCheckResultVo> queryHarmFactorLatestCheckResult(Long cid, Long factorId, List<Long> checkIds);


    /**
     * 按危害因素类型统计检测点，超标点
     * @param cid 企业id
     * @param year 检测的年份
     * @return
     */
    List<FactorTypeCheckPointVo> queryFactorTypeCheckPoint(Long cid, Integer year);

    /**
     * 按危害因素类型统计检测点，超标点
     * @param cid 企业id
     * @param year 检测的年份
     * @return
     */
    List<FactorTypeCheckPointVo> queryFactorTypeCheckPoint2(Long cid, Integer year);

    /**
     * 获取检测涉及的采样点，以及该采样点对应的危害因素
     * @param param
     * @param checkId
     * @param searchKey 采样点或危害因素名称
     * @return
     */
    @Deprecated // 过时 用querySelectPointVosGroupByCheckPoint这个方法
    PageInfo<SelectPointVo> querySelectPointVos(JqGridParam param, Long checkId, String searchKey);

    /**
     * 获取检测涉及的采样点，以及该采样点对应的危害因素 按采样点分组
     * @param param
     * @param checkId
     * @param searchKey 采样点或危害因素名称
     * @return
     */
    PageInfo<SelectPointVo> querySelectPointVosGroupByCheckPoint(JqGridParam param, Long checkId, String searchKey);
    /*
     * @Description:根据检测id和为哈因素获取检测结果
     * @Author: XiaoYi(肖奕)
     * @Date: 2020/10/21 13:59
     * @param: [checkId, harms]
     * @return: java.util.List<cn.smarthse.services.hfi.api.pojo.vo.HarmFactorCheckResultVo>
     **/
    List<HarmFactorCheckResultVo> queryHarmFactorByCheckAndHarms(Long checkId, List<Long> harms,List<String> source);

    List<HarmFactorCheckResultVo> queryHarmFactorByResultNo(Long resultNo);


    /**
     * 采样点 实施版
     * @param param
     * @param queryModel 参数对象
     * @return
     */
    PageInfo<CheckPointSelectVo> queryCheckPointSelectVos(JqGridParam param, CheckPointSelectVoParamModel queryModel);


    /**
     * 根据采样点和检测id获取危害因素id
     * @param checkId
     * @param checkPointName
     * @return
     */
    List<Long> queryFactorIdByCheckPoint(Long checkId, String checkPointName);

    /**
     * 从检测结果中 获取所有的检查item
     * @param checkId
     * @return
     */
    List<Long> getItemIds(Long checkId);


    /**
     * 查询有检测结果为空的检测id
     * @return
     */
    List<Long> queryHaveEmptyResultCheckIds();

    /**
     * 查询超标点（整改）
     * @param checkId
     * @return
     */
    List<CheckOverPointVo> queryCheckOverPointVo(Long checkId);

    /**
     * 通过riskid查找resultid集合
     * @param riskId
     * @return
     */
    List<Long> getResultIdByRiskId(Long riskId);
}
