package cn.smarthse.services.hfi.api.service;

import cn.smarthse.services.hfi.api.model.CheckComLevelClassifyResultVo;
import cn.smarthse.services.hfi.api.model.CheckResultParseQueryModel;
import cn.smarthse.services.hfi.api.pojo.vo.CheckFileVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo;

import java.util.List;
import java.util.Map;

/**
 * @author 邓力宾
 * @date 2020/10/22 16:47
 * @desc 检测结果解析接口
 */
public interface ICheckResultParseService {

    /**
     * 获取检测结果 按检测分组
     * @param queryModel 参数对象
     * @return
     */
    List<CheckFileVo> queryCheckFileVos(CheckResultParseQueryModel queryModel);

    /**
     * 获取检测结果
     * @param queryModel 参数对象
     * @return
     */
    List<CheckRecordFileVo> queryCheckRecordFileVos(CheckResultParseQueryModel queryModel);

    /**
     * @Comments:  <档案需要：  合并岗位信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2024/1/25-16:02
     * @param queryModel
     * @return java.util.List<cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo>
    */
    public List<CheckRecordFileVo> queryCheckRecordByArchive(CheckResultParseQueryModel queryModel);
    /**
     * 获取检测结果  一个企业只要最新的检测结果
     * @param queryModel 参数对象
     * @return
     */
    List<CheckRecordFileVo> queryComLatestCheckRecordFileVos(CheckResultParseQueryModel queryModel,Map<String, String> allIdAndNameMap);


    /**
     * 获取企业存在的危害因素
     * @param cid
     * @param checkYear 检测年份
     * @return
     */
    List<String> getAllFactorNames(Long cid, Integer checkYear);

    /**
     *  按当前时间往前1年时间内的检测结果（包括定期检测【03-009】、现状评价【03-018】、建设项目三同时【03-037】中的检测结果）存在重点职业病危害因素
     * 	（见危害因素数据表中评级危害字段中标1的危害），且危害因素的检测结果浓度≥（50%×限值）的企业 甲类； （ <50% * 限值为乙类）
     * @return
     */

    CheckComLevelClassifyResultVo parseComLevel1();
    /**
     *  按当前时间往前1年时间内的检测结果（包括定期检测【03-009】、现状评价【03-018】、建设项目三同时【03-037】中的检测结果）危害因素
     * 	（见危害因素数据表中评级危害字段中标2的危害），且危害因素的检测结果浓度≥（10%×限值）的企业 甲类；（ <10% * 限值为乙类）
     * @return
     */
    CheckComLevelClassifyResultVo parseComLevel2();
    /**
     *  按当前时间往前1年时间内的检测结果（包括定期检测【03-009】、现状评价【03-018】、建设项目三同时【03-037】中的检测结果）危害因素
     *  存在化学因素或矽尘大于限值的企业（甲类）
     * @return
     */
    Map<String, CheckComLevelClassifyResultVo> parseComLevel3();



    Map<String, String> getHarmIdAndNameMap();
}
