package cn.smarthse.services.hfi.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.services.hfi.api.entity.RayDevice;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.model.result.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface ICheckResultPageService {

    PageInfo<BiologicalListModel> biologicalPage(JqGridParam jparam,ListParamModel param);

    PageInfo<ChemicalListModel> chemicalPage(JqGridParam jparam,ListParamModel param);

    PageInfo<DustListModel> dustPage(JqGridParam jparam,ListParamModel param);

    PageInfo<FreshAirRateListModel> freshAirRatePage(JqGridParam jparam,ListParamModel param);

    PageInfo<HandTranSmittedListModel> handTranSmittedPage(JqGridParam jparam,ListParamModel param);

    PageInfo<HighFrequencyListModel> highFrequencyPage(JqGridParam jparam,ListParamModel param);

    PageInfo<HighTemperatureListModel> highTemperaturePage(JqGridParam jparam,ListParamModel param);

    PageInfo<IlluminancyListModel> illuminancyPage(JqGridParam jparam,ListParamModel param);

    PageInfo<RayDevice> ionizingRadiationPage(Long checkId, int pageNum, int pageSize);

    List<IonizingRadiationListModel> ionizingRadiationCheckPage(Long deviceId);

    List<IonizingRadiationListModel> rayDeviceList(Long deviceId,Integer type);

    PageInfo<RaySourceDevice> ionizingRadiationSourcePage(Long checkId, int pageNum, int pageSize);

    List<IonizingRadiationListModel> ionizingRadiationCheckSourcePage(Long sourceId);

    PageInfo<LaserRadiationListModel> laserRadiationPage(JqGridParam jparam,ListParamModel param);

    PageInfo<MicroclimateListModel> microclimatePage(JqGridParam jparam,ListParamModel param);

    PageInfo<MicrowaveRadiationListModel> microwaveRadiationPage(JqGridParam jparam,ListParamModel param);

    PageInfo<NoiseListModel> noisePage(JqGridParam jparam,ListParamModel param);

    PageInfo<PowerFrequencyListModel> powerFrequencyPage(JqGridParam jparam,ListParamModel param);

    PageInfo<UltrahighFrequencyRadiationListModel> ultrahighFrequencyRadiationPage(JqGridParam jparam,ListParamModel param);

    PageInfo<UltravioletLightListModel> ultravioletLightPage(JqGridParam jparam,ListParamModel param);

    PageInfo<WindSpeedListModel> windSpeedPage(JqGridParam jparam,ListParamModel param);

    PageInfo<RadiateRiskListModel> radiateRiskPage(JqGridParam jparam, ListParamModel param);

    /**************************List********************************/
    List<BiologicalListModel> biologicalList(Long checkId,Long itemId);

    List<ChemicalListModel> chemicalList(Long checkId,Long itemId);

    List<DustListModel> dustList(Long checkId,Long itemId);

    List<FreshAirRateListModel> freshAirRateList(Long checkId,Long itemId);

    List<HandTranSmittedListModel> handTranSmittedList(Long checkId,Long itemId);

    List<HighFrequencyListModel> highFrequencyList(Long checkId,Long itemId);

    List<HighTemperatureListModel> highTemperatureList(Long checkId,Long itemId);

    List<IlluminancyListModel> illuminancyList(Long checkId,Long itemId);

    List<RayDeviceExportModel> ionizingRadiationList(Long checkId);

    List<RaySourceDeviceExportModel> ionizingRadiationSourceList(Long checkId);

    List<LaserRadiationListModel> laserRadiationList(Long checkId,Long itemId);

    List<MicroclimateListModel> microclimateList(Long checkId,Long itemId);

    List<MicrowaveRadiationListModel> microwaveRadiationList(Long checkId,Long itemId);

    List<NoiseListModel> noiseList(Long checkId,Long itemId);

    List<PowerFrequencyListModel> powerFrequencyList(Long checkId,Long itemId);

    List<UltrahighFrequencyRadiationListModel> ultrahighFrequencyRadiationList(Long checkId,Long itemId);

    List<UltravioletLightListModel> ultravioletLightList(Long checkId,Long itemId);

    List<WindSpeedListModel> windSpeedPList(Long checkId,Long itemId);

    List<RadiateRiskListModel> radiateRiskList(ListParamModel param);


    Integer getAllCountResultDataByHcId(Long hcId);

    void updateRayResult(RayDeviceFormModel model);


}
