package cn.smarthse.services.hfi.api.service;

import cn.smarthse.services.hfi.api.pojo.vo.CheckFileVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2020/10/20 10:26
 * @desc 检测 档案相关接口
 */
public interface ICheckRecordFileService {

    /**
     * 获取检测结果 按检测分组
     * @param cid 企业id
     * @param checkBeginStart 检测开始时间 范围下限
     * @param checkBeginEnd 检测开始时间 范围上限
     * @return
     */
    List<CheckFileVo> queryCheckFileVos(Long cid, LocalDateTime checkBeginStart,
                                        LocalDateTime checkBeginEnd);

    /**
     * 获取检测结果
     * @param cid 企业id
     * @param checkBeginStart 检测开始时间 范围下限
     * @param checkBeginEnd 检测开始时间 范围上限
     * @return
     */
    List<CheckRecordFileVo> queryCheckRecordFileVos(Long cid, LocalDateTime checkBeginStart,
                                                    LocalDateTime checkBeginEnd);





}
