package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckPointIgnore;

import java.util.List;

/**
 * <p>
 * 采样点忽略表（实施） 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-10-23
 */
public interface ICheckPointIgnoreService extends IBaseService<CheckPointIgnore> {

    /**
     * 忽略
     * @param cid 企业id
     * @param checkPointResultNos 采样点的结果集编号
     */
    void ignore(Long cid, List<Long> checkPointResultNos);


    /**
     * 从忽略中移除（恢复）
     * @param cid 企业id
     * @param checkPointResultNos 采样点的结果集编号
     */
    void removeIgnore(Long cid, List<Long> checkPointResultNos);

    /**
     * 根据企业id获取已忽略的检测点（结果集编号）
     * @param cid 企业id
     * @return
     */
    List<Long> getByCid(Long cid);
}
