package cn.smarthse.services.hfi.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.ComCheckQueryModel;
import cn.smarthse.services.hfi.api.model.CountParamModel;
import cn.smarthse.services.hfi.api.model.doc.Doc4CheckFile;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.model.smarthse.CheckPlanResultCountMdoel;
import cn.smarthse.services.hfi.api.pojo.bo.CheckPlanCountBo;
import cn.smarthse.services.hfi.api.pojo.bo.ScaleCompanyCheckNumBo;
import cn.smarthse.services.hfi.api.pojo.vo.*;
import com.github.pagehelper.PageInfo;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 检测表 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
public interface ICheckPlanService extends IBaseService<CheckPlan> {

    /**
     * 最近一年(有报告出具时间在近一年时间内) 的定期检测检测（来自机构端） 按cid排序
     * @return
     */
    List<CheckPlan> queryForOverRate();

    /**
     * 获取所有的企业id（去重）按id升序
     * @return
     */
    List<Long> getAllCid();

    /**
     * 根据检测时间范围查询检测
     * @param startDate
     * @param endDate
     * @param reportStatus 1:未上报 2：已上报 3：被退回
     * @param  checkType 2:定期检测 3：评价检测 4：控评检测
     * @return
     */
    List<Long> getCheckIdByDateRange(LocalDateTime startDate, LocalDateTime endDate,
                                     Integer reportStatus, Integer checkType);

    /**
     * 获取机构对指定的企业（多个）最近一次检测开始时间
     * @param orgId
     * @param cids
     * @return
     */
    LocalDateTime getLastCheckStartTimeByOrg(Long orgId, List<Long>cids);


    /**
     * 查询 企业最近一次定期检测的日期
     * @return
     */
    List<ComLatestCheckDate> getComLatestCheckDate();

    List<CheckPlanList> getCheckPlanList(CheckPlanListParam param);

    /**
     * @param jparam
     * @param param
     * @param count 是否要返回总数
     * @return
     */
    PageInfo<CheckPlanList> getCheckPlanPage(JqGridParam jparam, CheckPlanListParam param, Boolean count);

    /**
     * 根据条件获取最新一次检测id
     * @param param
     * @return
     */
    Long getCheckPlanIdBySearch(CheckPlanListParam param);

    /**
     * @Comments:  <获取每个企业最新的一条检测数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2024/1/24-15:27
     * @param param
     * @return java.util.List<cn.smarthse.services.hfi.api.entity.CheckPlan>
    */
    List<CheckPlan> getLastCheckPlanInfo(CheckPlanListParam param);
    /**
     * 按年份统计有检测的企业数
     * @param areaId  区域id
     * @param areaLevel 区域级别
     * @param year 年份 为null  则统计所有 年份
     * @return
     */
    Integer countComNumByYearByArea(Long areaId, Byte areaLevel, Integer year,Byte ownLevel);



    /**
     * 根据检测的时间范围统计检测的企业数
     * @param areaId 区域id
     * @param areaLevel 区域级别
     * @param start
     * @param end
     * @return
     */
    Integer countComNumByTimeRangeByArea(Long areaId, Byte areaLevel, LocalDateTime start, LocalDateTime end,Byte ownLevel);



    /**
     * 按行业统计已检测企业数
     * @param areaId 区域id
     * @param areaLevel 区域级别
     * @param industryIds 行业id 多个
     * @param start 检测时间范围 开始
     * @param end 检测时间范围 结束
     * @return
     */
    Integer countComNumByYearByIndustryByArea(Long areaId, Byte areaLevel,List<Long> industryIds,
                                        LocalDateTime start, LocalDateTime end,Byte ownLevel);

    /**
     * 根据企业包含的危害因素和时间范围 统计已检测企业数
     * @param cids
     * @param start
     * @param end
     * @return
     */
    Integer countComNumByTimeRangeByFactorByArea(Long areaId, Byte areaLevel,
                                                 List<Long> cids, LocalDateTime start, LocalDateTime end,Byte ownLevel);

    /**
     * 按规模统计已检测企业数
     * @param start 检测时间范围
     * @param end
     * @return
     */
    List<ScaleCompanyCheckNumBo> countComNumByAreaGroupByScale(Long areaId, Byte areaLevel,
                                                               LocalDateTime start, LocalDateTime end,Byte ownLevel);


    CheckPlan getDetailById(Long id);

    /**
     * 退回
     * @param id
     * @param updateBy
     */
    void reback(Long id,Long updateBy);

    /**
     * 职业病危害因素检测结果统计
     * @param year
     * @param cid
     * @return
     */
    CheckPlanResultCountMdoel smarthseCount(Integer year,Long cid);

    /**
     * 企业端-职业病危害因素检测结果统计 实施版
     * @param year
     * @param cid
     * @return
     */
    CheckPlanResultCountMdoel comCheckPlanCount(Integer year,Long cid);

    void deleteById(Long id, Long userId);

    CheckPlan getNotValidHcCheckThirdOrgPlan(Long cid, Long createBy,Integer checkType, Integer from);

    /**
     * 根据评价id查询对应的检测
     * @param evaluateId
     * @return
     */
    CheckPlan getByEvaluateId(Long evaluateId);

    /**
     * 根据评价id删除对应的检测
     * @param evaluateId
     */
    void deleteByEvaluateId(Long evaluateId);

    /**
     * 根据检测的开始时间和结果时间范围查询
     * @param cid 企业id
     * @param endDateMin 检测结束时间下限
     * @param startDateMax 检测开始时间上限
     * @return 检测列表 按 更新时间倒序
     */
    List<CheckPlan> getByStartDateAndEndDateRange(Long cid, LocalDateTime endDateMin, LocalDateTime startDateMax);

    /**
     * 获取检测的结束时间小于某个时间的最近一条记录，没有返回null
     * @param cid
     * @param endDateMax
     * @return
     */
    CheckPlan getLatestByEndDateMin(Long cid, LocalDateTime endDateMax);

    /**
     * 获取最近一次职业病危害因素检测时间
     * @param cid
     */
    CheckPlan getLatestOccHazardFac(Long cid);

    /**
     * 获取检测的结束时间小于某个时间的最近一条记录，没有返回null
     * @param cid
     * @param endDateMax
     * @param checkTypes 检测类型
     * 1, '日常监测'
     * 2, '定期检测'
     * 3, '现状评价涉及的检测'
     * 4, '控评涉及的检测'
     * 5, '整改后检测'
     * @return
     */
    CheckPlan getLatestByEndDateMinAndType(Long cid, LocalDateTime endDateMax, List<Long> checkTypes);

    /**
     * 获取检测使用的标准id
     * @return
     */
    Map<Long, Long> getCheckIdToStandardId();

    /**
     * 返回企业id列表
     * @param areaId
     * @param areaLevel
     * @param start
     * @param end
     * @return
     */
    List<Long> getCidList(Long areaId, Byte areaLevel, LocalDateTime start, LocalDateTime end);

    /**
     * 获取没有统计的超标率的检测id 按id排序
     * @return
     */
    List<Long> getUnCheckedOverPoint(List<Long> cidList);

    /**
     * 统计机构在指定年份指定区域上报检测数量
     * @param orgIds 为null统计所有机构
     * @param year 可以为null
     * @param areaId 区域id
     * @param areaLevel 区域级别
     * @return
     */
    Map<Long, Integer> countGroupByOrg(Long[] orgIds, Integer year, Long areaId, Byte areaLevel);

    /**
     * 上报项目总数
     * @param year 上报年份 可以为null
     * @param areaId 区域id
     * @param areaLevel 区域级别
     * @param ownLevel 可为null 1:本级省 2：本级市
     * @return
     */
    Integer countProjectNum(Integer year, Long areaId, Byte areaLevel, Byte ownLevel);

    /**
     * 在指定区域开展业务的机构
     * @param areaId
     * @param areaLevel
     * @param ownLevel 只查直属级别（1：省 2：市）的企业
     * @return
     */
    Long[]  getOrgIdByArea( Long areaId, Byte areaLevel, Byte ownLevel);
   /*
    * @Description:在本辖区上报过检测项目的机构
    * @Author: XiaoYi(肖奕)
    * @Date: 2021/1/11 10:36
    * @param: [areaId, areaLevel]
    * @return: java.util.List<java.lang.Long>
    **/
    List<Long> getOrgIdListByaArea(Long areaId, Byte areaLevel);


    /**
     * 检测列表统计查询 实施版
     * @param queryModel
     * @param jqGridParam
     * @return
     */
    PageInfo<ComCheckPlanListVo> comQueryList(ComCheckQueryModel queryModel, JqGridParam jqGridParam);

    /**
     * 移除待上报状态 实施版
     * @param checkId
     */
    void removeCheckReport(Long checkId);

    /**
     * 更新数据关联工作状态
     * @param checkId
     * @param relevanceStatus
     */
    void updateRelevanceStatus(Long checkId,Integer relevanceStatus);

    List<Doc4CheckFile> getDoc4CheckFiles(Long cid,Integer year);

    List<Long> getTpCompanyIdsFromHcCheck(Long cid, int year);

    /**
     * 统计数据 实施版
     * @param jparam
     * @param paramVo
     * @return
     */
    PageInfo<HcCheckPlanCountDailyPageVo> getHcCheckPlanCountDailyPage(JqGridParam jparam, HcCheckPlanCountDailyPageParamVo paramVo);

    /**
     * 统计数据 实施版
     * @param year
     * @param cid
     * @param checkType
     * @return
     */
    HcCheckPlanCountVo getHcCheckPlanCompletedCountByYearAndType(Integer year, Long cid, Long checkType);

    /**
     * 获取企业最近一次检测 的年份
     * @param cid
     * @return
     */
    Integer getLatestCheckYear(Long cid);

    LocalDateTime getLatestCheckDate(Long cid);
    /*
     * @Comments:  <获取指定年份  最终的上报记录>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/3/31-17:38
     * @param cid
     * @param year
     * @return java.time.LocalDateTime
    */
    public LocalDateTime getFirstCheckDateByYear(Long cid, Integer year);

    /**
     * 根据检测id获取检测名称 格式： 检测id-> 工作名称（检测时间）
     * @param ids
     * @return
     */
    Map<Long, String> getWorkNameByIds(List<Long> ids);

    /**
     * 根据检测id获取检测
     * @param ids
     * @return
     */
    Map<Long, CheckPlan> getMapByIds(List<Long> ids);


    /**
     * 最近一年有定期检测的企业id
     * @return
     */
    List<Long> getCidLatestYear();

    /**
     * 检测次数统计
     * @param countParamModel
     * @return
     */
    Integer countCheck(CountParamModel countParamModel);

    /**
     * 根据检查状态获取对应的整改项id
     * @param countParamModel
     * @return 整改项id
     */
    List<Long> getReformIds(CountParamModel countParamModel);

    /**
     * 获取检测id和cid(只获取cid错误的数据)
     * @return
     */
    List<CheckPlan> getAllNeedIdAndCheckId();

    /**
     * 检测点分布示意图 文件id
     * @param cid 企业id
     * @param timeStart 检测开始时间
     * @param timeEnd 检测结束时间
     * @return
     */
    String getCheckPointMapFileIds(Long cid, String timeStart, String timeEnd);
    /**
     * 检测报告图 文件id
     * @param cid 企业id
     * @param timeStart 检测开始时间
     * @param timeEnd 检测结束时间
     * @return
     */
    String getCheckReportFileIds(Long cid, String timeStart, String timeEnd);

    /**
     * 检测的第三方机构id
     * @param cid 企业id
     * @param timeStart 检测开始时间
     * @param timeEnd 检测结束时间
     * @return
     */
    List<Long> getThirdOrgId(Long cid, String timeStart, String timeEnd);

    List<Long> getCidListByFactorAndArea(Long areaId, Byte areaLevel,Integer checkYear,List<Long> harmIds);

    /**
     * 根据编号查询
     * @param workNo
     * @return
     */
    CheckPlan getByWorkNo(String workNo);

    /**
     * 根据企业和机构查询最新一条
     * @param orgId
     * @param cid
     * @return
     */
    CheckPlan getLatestByOrgAndCom(Long orgId, Long cid);

    List<Long> getCidByOrgId(Long orgId);

    /**
     * 暴露上报同步数据到检测
     *
     */
    List<CheckPlan> autoAddAllRiskToCheck(List<Long> idList);

    /**
     * 获取没有统计的检测涉及的危害因素
     * @return
     */
    List<CheckPlan> getUnCheckedFactor(List<Long> cidList);

    /**
     * 获取每个公司的最新检测checkid
     *
     * @param cidList      cid列表  为空查询所有
     * @param reportStatus 报告状态 为空查所有
     * @return {@link List }<{@link Long }>
     * @author zhangxu
     * @date 2023-05-14
     */
    List<Long> getLastCheckPlanGroupByCid(List<Long> cidList,Integer reportStatus);

    public List<CheckPlan> getLastCheckPlanGroupByCid2(List<Long> cidList, Integer reportStatus);
    /**
     * 获取最新检测
     *
     * @param cid          cid
     * @param reportStatus 报告状态
     * @return {@code CheckPlan }
     * @author zhangxu
     * @date 2023-05-19
     */
    CheckPlan getLastCheckPlanByCid(Long cid,Integer reportStatus);


    /**
     * 获取万达仓对接检测数据生成暴露风险上报数据
     *
     * @param wandaCheckIdList 列表
     * @author zhangxu
     * @date 2023-03-22
     */
    void autoAddCheckPlanFromWandaCheck(List<Long> wandaCheckIdList);

    /**
     * 获取万达仓对接检测数据生成暴露风险上报数据（更新数据，比如退回或者本地删除了）
     *
     * @param wandaCheckIdList 列表
     * @author zhangxu
     * @date 2023-03-22
     */
    void autoUpdateCheckPlanFromWandaCheck(List<Long> wandaCheckIdList);

    /**
     * 校验数据并返回万达
     *
     * @param wandaZywsCheckIdList 万达zyws检查id列表
     * @author zhangxu
     * @date 2023-05-10
     */
    void inspectionAndReturnWanda(List<Long> wandaZywsCheckIdList);

    /**
     * 最早得到检查一年
     *
     * @param cid        cid
     * @param checkTypes 检查类型
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-16
     */
    Integer getEarliestCheckYear(Long cid, List<String> checkTypes);

    List<CheckPlan> getLastUpdateCid(Date updateDate);


    PageInfo<CheckPlan> getNeedConvertFile(int pageNum, int pageSize);

    List<CheckPlan> selectCheckPlanList(CheckPlanListParam param);

    /**
     * 最近一次检测是否存在超标
     * @param cid
     * @return
     */
    Boolean exitOverStandardLastly(Long cid);


    List<CheckPlanCountBo> collectFinishCheck(List<Long> cidList);

    String getEarlyCheckPlan(Long cid, List<Integer> typeList,Map<String,String> param);
}
