package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.pojo.bo.ComCheckPointBo;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 检测超标统计（统计表） 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-27
 */
public interface ICheckOverPointService extends IBaseService<CheckOverPoint> {

    /**
     * 根据检测id查询
     * @param checkIds
     * @return
     */
    List<CheckOverPoint> getByCheckIds(List<Long> checkIds);

    /**
     * 根据企业分组统计检测点，超标点个数（本年度）
     * @return
     */
    List<ComCheckPointBo> countByCom();

    /**
     * 根据企业分组统计检测点，超标点个数 时间范围 （都为null 则查本年度）
     * @param startBegin
     * @param end
     * @return
     */
    List<ComCheckPointBo> countByCom(LocalDateTime startBegin, LocalDateTime end);
}
