package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckHistoryData;
import cn.smarthse.services.hfi.api.model.CheckHistoryDataModel;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 检测历史数据 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-09-10
 */
public interface ICheckHistoryDataService extends IBaseService<CheckHistoryData> {


    /**
     * 保存一份快照数据(添加或修改了检测数据之后调用，异步执行)
     * @param checkId
     */
    void saveSnapshoot(Long checkId);

    /**
     * 根据检测查询历史数据 按备份时间排序
     * @param checkId 检测id
     * @param startDate  时间范围 备份开始时间
     * @param endDate  时间范围 备份开始时间
     * @return
     */
    List<CheckHistoryDataModel> getByCheckId(Long checkId, LocalDateTime startDate, LocalDateTime endDate);

    /**
     * 根据企业查询历史数据 按备份时间排序
     * @param cid 企业id
     * @param startDate 时间范围 备份开始时间
     * @param endDate 时间范围 备份开始时间
     * @return
     */
    List<CheckHistoryDataModel> getByCid(Long cid, LocalDateTime startDate, LocalDateTime endDate);
}
