package cn.smarthse.services.hfi.api.service;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.hfi.api.entity.CheckFactor;
import cn.smarthse.services.hfi.api.model.ComFactorQueryModel;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 检测涉及的危害因素表（统计表） 服务类
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-25
 */
public interface ICheckFactorService extends IBaseService<CheckFactor> {

    /**
     * 开始统计，立即执行， 比较耗时（可以定时执行）
     */
    void startStatistic(List<Long> cidList);

    /**
     * 根据检测id统计
     * @param checkId
     */
    void startStatisticByCheckId(Long checkId, Long cid);

    /**
     * 查询企业在指定时间范围内的检测涉及到的危害因素
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @param  reportStatus 1:未上报 2：已上报 3：被退回
     * @param  checkType 2:定期检测 3：评价检测 4：控评检测
     * @return 企业id-危害因素id集合
     * 过时 用这个方法 {@link ICheckFactorService#getComFactorIds(cn.smarthse.services.hfi.api.model.ComFactorQueryModel)}
     */
     @Deprecated
     Map<Long, List<Long>> getComFactorIds(LocalDateTime startDate, LocalDateTime endDate,
                                           Integer reportStatus,
                                           Integer checkType);

     /**
     * 查询企业存在的危害因素
     * @param queryModel 查询参数对象
     * @return 企业id-危害因素id集合
     */
     Map<Long, List<Long>> getComFactorIds(ComFactorQueryModel queryModel);



    /**
     * 获取检测涉及的危害因素
     * @param cid 企业id
     * @param checkYear 检测年份
     * @return
     */
     List<String> getCheckFactor(Long cid, Integer checkYear);

}
