package cn.smarthse.services.hfi.api.pojo.vo.riskev;

import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import lombok.Data;

/**
 * @author 吴嘉诚
 * @date 2022/3/17 11:03
 * @desc
 */
@Data
public class RiskExposeEvaluateVo extends RiskExposeEvaluate {

    private String comName; //委托单位名称

    //如果tableType=1时就和以前一样的取值
    private String orgName;//机构名称
    private String reportStatusStr;    //提交状态

    //如果tableType=2时就取下面的值
    //放射检测机构
    private String orgName1;//机构名称
    private Integer reportStatus1;    //提交状态
    //职业健康体检机构
    private String orgName2;//机构名称
    private Integer reportStatus2;    //提交状态

    //默认tableType=1时和原来一样，tableType=2时就是显示两个机构
    private Integer tableType=1;


    public String getReportStatusStr() {
        //1:待提交 2：待审核 3：被退回待提交 4：审核完成
        switch (this.getReportStatus()){
            case 1:
                return "待提交";
            case 2:
                return "待审核";
            case 3:
                return "被退回待提交";
            case 4:
            case 5:
                return "审核完成";
            case 10:
                return "已退回";//错误数据
            default:
                return "";
        }
    }
}
