package cn.smarthse.services.hfi.api.pojo.vo.riskev;

import cn.smarthse.db.common.entity.BaseEntity;
import lombok.Data;

/**
 * @author 吴嘉诚
 * @date 2022/3/22 9:29
 * @desc generalOverStaffCount  一般职业病危害因素超标人数  generalTotalStaffCount 一般职业病危害因素总人数
 *       seriousOverStaffCount  严重职业病危害因素超标人数 seriousOverTotalStaffCount 严重职业病危害因素总人数
 */
@Data
public class RiskDecisionVo extends BaseEntity {

    private Integer generalOverStaffCount = 0; //一般超标人数

    private Integer generalNotOverStaffCount = 0; //一般不超标人数

    private Integer generalTotalStaffCount;

    private String generalOverRiskLevel;   //一般职业病危害因素超标人数风险等级

    private String generalNotOverRiskLevel;    //一般职业病危害因素未超标人数风险等级


    private Integer seriousOverStaffCount = 0; //严重超标人数

    private Integer seriousNotOverStaffCount = 0; //严重不超标人数

    private Integer seriousOverTotalStaffCount;

    private String seriousOverRiskLevel;   //严重职业病危害因素超标人数风险等级

    private String seriousNotOverRiskLevel;    //严重职业病危害因素未超标人数风险等级


    private String riskLevel;   //职业病危害暴露风险等级


    public Integer getGeneralTotalStaffCount(){
        return generalNotOverStaffCount + generalOverStaffCount;
    }


    public Integer getSeriousOverTotalStaffCount(){
        return seriousNotOverStaffCount + seriousOverStaffCount;
    }

}
