package cn.smarthse.services.hfi.api.pojo.vo.riskev;

import cn.smarthse.services.hfi.api.enums.HazardsExposureRiskLevelEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 职业病危害风险等级
 *
 * @author ShenZQ
 * @since 2022/11/3 10:42
 */
@Data
public class HazardsExposureRiskLevelVo implements Serializable {

    private static final long serialVersionUID = -2881496833912878375L;

    private String riskLevel = HazardsExposureRiskLevelEnum.none.getName();   //职业病危害暴露风险等级

    private String generalNotOverRiskLevel = HazardsExposureRiskLevelEnum.none.getName();    //一般职业病危害因素未超标人数风险等级
    private String generalOverRiskLevel = HazardsExposureRiskLevelEnum.none.getName();   //一般职业病危害因素超标人数风险等级
    private String seriousNotOverRiskLevel = HazardsExposureRiskLevelEnum.none.getName();    //严重职业病危害因素未超标人数风险等级
    private String seriousOverRiskLevel = HazardsExposureRiskLevelEnum.none.getName();   //严重职业病危害因素超标人数风险等级
}
