package cn.smarthse.services.hfi.api.pojo.vo;

import cn.smarthse.util.common.date.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author 邓力宾
 * @date 2020/10/16 15:42
 * @desc 采样点选择
 */
@Data
public class SelectPointVo implements Serializable {
    private Long checkId; //检测id

    private String pointName;//采样点名称

    private String reportName; //采样点（同上）

    private Integer targetId;//采样点对应的指标id

    private Long itemId; // 指标所属检测项目id

    private Long resultNo;//结果集编号

    private String factorId;//存在的危害因素id

    private String factorName;//存在的危害因素名称
    private String harmFactorNames;//存在的危害因素名称



    // 危害因素名称和id,便于危害因素管理模块保存 危害因素id（格式为：name1:id1~&~name2:id2~&~name3:id3,  如：危害因素名称1:危害因素id1~&~危害因素名称2:危害因素id2~&~危害因素名称3:危害因素id3）
    private String harmFactorNamesAndIds;

    private String rowId; //行id 表示一行

    private String checkStartTime;
    private LocalDateTime checkDateBegin;


    public String getReportName(){
        return this.reportName;
    }

    public String getHarmFactorNames(){
        return this.factorName;
    }

    public String getCheckStartTime(){
        if(this.checkDateBegin == null){
            return "";
        }
        return DateUtils.formatDate(checkDateBegin, "yyyy-MM-dd");
    }
}
