package cn.smarthse.services.hfi.api.pojo.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * @author 邓力宾
 * @date 2020/11/10 11:08
 * @desc 监管端，危害因素超标企业数统计vo
 */
@Data
public abstract class HarmComStatBaseVo implements Serializable {
    private String harmId;//危害因素id

    private String harmName;//危害因素名称


    private Integer totalCount = 0;//企业总数

    private Integer overProofCount = 0;//超标企业数

    private Integer noOverProofCount = 0;//未超标企业数

    private String overRate = "";//超标率


    private Set<Long> allCids = new HashSet<>(); //所有企业id

    private Set<Long> overProofCountCids = new HashSet<>();//超标企业id

    private Set<Long> noOverProofCountCids = new HashSet<>();//未超标企业id



    //以下字段用于分组 分组类型：行政区划、经济类型、行业类别、企业规模、风险分类
    private String groupName; //分组名称 如果按行政区划分组 如：杭州市，湖州市
    private String groupKey;//分组key 如果按行政区划分组 可以设置成区域id

    public Integer getTotalCount() {
        return getAllCids().size();
    }

    public Integer getOverProofCount() {
        return getOverProofCountCids().size();
    }

    public Integer getNoOverProofCount() {
        return getNoOverProofCountCids().size();
    }

    public String getOverRate() {
        if(!getTotalCount().equals(0)){
            return ((getOverProofCount()) * 100 / getTotalCount()) +"%"; //超标率
        }
        return "0%";
    }
}
